/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.provider.Arguments;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV1;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.packstream.Neo4jPackV3;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;

public abstract class AbstractBoltTransportsTest {
    private static final List<Class<? extends TransportConnection>> CONNECTION_CLASSES = Arrays.asList(SocketConnection.class, WebSocketConnection.class, SecureSocketConnection.class, SecureWebSocketConnection.class);
    private static final List<Neo4jPack> NEO4J_PACK_VERSIONS = Arrays.asList(new Neo4jPackV1(), new Neo4jPackV2(), new Neo4jPackV3());
    public Class<? extends TransportConnection> connectionClass;
    public Neo4jPack neo4jPack;
    public String name;
    protected HostnamePort address;
    protected TransportConnection connection;
    protected TransportTestUtil util;

    protected void initParameters(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack, String name) throws Exception {
        this.connectionClass = connectionClass;
        this.neo4jPack = neo4jPack;
        this.name = name;
        this.connection = this.newConnection();
        this.util = new TransportTestUtil(neo4jPack);
    }

    @AfterEach
    public void disconnectFromDatabase() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    protected static Stream<Arguments> argumentsProvider() {
        ArrayList<Arguments> result = new ArrayList<Arguments>();
        for (Class<? extends TransportConnection> connectionClass : CONNECTION_CLASSES) {
            for (Neo4jPack neo4jPack : NEO4J_PACK_VERSIONS) {
                result.add(Arguments.of((Object[])new Object[]{connectionClass, neo4jPack, AbstractBoltTransportsTest.newName(connectionClass, neo4jPack)}));
            }
        }
        return result.stream();
    }

    protected TransportConnection newConnection() throws Exception {
        return this.connectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void reconnect() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.connection = this.newConnection();
    }

    protected Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return Neo4jWithSocket.withOptionalBoltEncryption();
    }

    private static String newName(Class<? extends TransportConnection> connectionClass, Neo4jPack neo4jPack) {
        return connectionClass.getSimpleName() + " & " + String.valueOf(neo4jPack);
    }
}

