/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.provider.Arguments;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.testing.MessageConditions;
import org.neo4j.bolt.testing.TransportTestUtil;
import org.neo4j.bolt.testing.client.SecureSocketConnection;
import org.neo4j.bolt.testing.client.SecureWebSocketConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.WebSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.bolt.v3.BoltProtocolV3ComponentFactory;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.fabric.config.FabricSettings;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
public abstract class BoltV3TransportBase {
    protected static final String USER_AGENT = "TestClient/3.0";
    @Inject
    public Neo4jWithSocket server;
    protected HostnamePort address;
    protected TransportConnection connection;
    protected TransportTestUtil util;

    private static Stream<Arguments> argumentsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{SocketConnection.class}), Arguments.of((Object[])new Object[]{WebSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureSocketConnection.class}), Arguments.of((Object[])new Object[]{SecureWebSocketConnection.class}));
    }

    protected void init(Class<? extends TransportConnection> connectionClass) throws Exception {
        this.connection = connectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) throws IOException {
        this.server.setConfigure(settings -> {
            Neo4jWithSocket.withOptionalBoltEncryption().accept(settings);
            settings.put(FabricSettings.enabled_by_default, this.fabricEnabled());
        });
        this.server.init(testInfo);
        this.address = this.server.lookupDefaultConnector();
        this.util = new TransportTestUtil(BoltProtocolV3ComponentFactory.newMessageEncoder());
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    protected boolean fabricEnabled() {
        return true;
    }

    protected void negotiateBoltV3() throws Exception {
        this.connection.connect(this.address).send(TransportTestUtil.acceptedVersions((long)3L, (long)0L, (long)0L, (long)0L)).send(this.util.chunk(new RequestMessage[]{new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", USER_AGENT}))}));
        Assertions.assertThat((Object)this.connection).satisfies(TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 3}));
        Assertions.assertThat((Object)this.connection).satisfies(this.util.eventuallyReceives(new Consumer[]{MessageConditions.msgSuccess()}));
    }
}

