/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class SchedulerBusyIT {
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    @Inject
    private Neo4jWithSocket server;

    @FactoryFunction
    void customizeDatabase(TestDatabaseManagementServiceBuilder factory) {
        factory.setInternalLogProvider((InternalLogProvider)this.internalLogProvider);
        factory.setUserLogProvider((LogProvider)this.userLogProvider);
    }

    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.thread_pool_min_size, 0);
        settings.put(BoltConnector.thread_pool_max_size, 2);
    }

    @AfterEach
    void cleanup() {
        this.internalLogProvider.clear();
        this.userLogProvider.clear();
    }

    private static void enterStreaming(BoltWire wire, TransportConnection connection) throws IOException {
        connection.send(wire.run("UNWIND RANGE (1, 100) AS x RETURN x"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    private static void exitStreaming(BoltWire wire, TransportConnection connection) throws IOException {
        connection.send(wire.discard());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    @TransportTest
    void shouldReportFailureWhenAllThreadsInThreadPoolAreBusy(BoltWire wire, @Authenticated TransportConnection connection1, @Authenticated TransportConnection connection2, @Negotiated TransportConnection connection3) throws IOException {
        SchedulerBusyIT.enterStreaming(wire, connection1);
        SchedulerBusyIT.enterStreaming(wire, connection2);
        connection3.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection3).receivesFailureFuzzy((Status)Status.Request.NoThreadsAvailable, "There are no available threads to serve this request at the moment");
        LogAssertions.assertThat((AssertableLogProvider)this.userLogProvider).forLevel(AssertableLogProvider.Level.ERROR).containsMessages(new String[]{"since there are no available threads to serve it at the moment. You can retry at a later time"});
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.ERROR).containsMessages(new String[]{"since there are no available threads to serve it at the moment. You can retry at a later time"});
        BoltConnectionAssertions.assertThat((TransportConnection)connection3).isEventuallyTerminated();
    }

    @TransportTest
    void shouldOperateNormallyWhenThreadsFreeUp(BoltWire wire, @Authenticated TransportConnection connection1, @Authenticated TransportConnection connection2, @Negotiated TransportConnection connection3, @Negotiated TransportConnection connection4) throws IOException {
        SchedulerBusyIT.enterStreaming(wire, connection1);
        SchedulerBusyIT.enterStreaming(wire, connection2);
        SchedulerBusyIT.exitStreaming(wire, connection1);
        connection3.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection3).receivesSuccess();
        SchedulerBusyIT.exitStreaming(wire, connection2);
        connection4.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection4).receivesSuccess();
    }

    @TransportTest
    void shouldStopConnectionsWhenRelatedJobIsRejectedOnShutdown(BoltWire wire, @Authenticated TransportConnection connection1, @Authenticated TransportConnection connection2, @Authenticated TransportConnection connection3, @Authenticated TransportConnection connection4) throws IOException {
        SchedulerBusyIT.enterStreaming(wire, connection1);
        SchedulerBusyIT.exitStreaming(wire, connection1);
        SchedulerBusyIT.enterStreaming(wire, connection2);
        SchedulerBusyIT.exitStreaming(wire, connection2);
        SchedulerBusyIT.enterStreaming(wire, connection3);
        SchedulerBusyIT.enterStreaming(wire, connection4);
        this.server.shutdownDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.userLogProvider).doesNotContainMessage("since there are no available threads to serve it at the moment. You can retry at a later time");
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).doesNotContainMessage("since there are no available threads to serve it at the moment. You can retry at a later time");
        BoltConnectionAssertions.assertThat((TransportConnection)connection1).isEventuallyTerminated();
        BoltConnectionAssertions.assertThat((TransportConnection)connection2).isEventuallyTerminated();
        BoltConnectionAssertions.assertThat((TransportConnection)connection3).isEventuallyTerminated();
        BoltConnectionAssertions.assertThat((TransportConnection)connection4).isEventuallyTerminated();
    }
}

