/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.v40;

import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.bolt.fsm.v40.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.Signal;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v40.fsm.FailedState;
import org.neo4j.bolt.protocol.v40.fsm.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;

class FailedStateIT
extends BoltStateMachineV4StateTestBase {
    FailedStateIT() {
    }

    @ParameterizedTest
    @MethodSource(value={"ignoredMessages"})
    void shouldIgnoreMessages(RequestMessage message) throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInFailedState();
        machine.process(message, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(FailedState.class);
    }

    @Test
    void shouldMoveToInterruptedOnInterruptSignal() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInFailedState();
        machine.process((RequestMessage)Signal.INTERRUPT, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InterruptedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV4Messages(RequestMessage message) throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInFailedState();
        StateMachineAssertions.assertThat((StateMachine)machine).shouldKillConnection(fsm -> fsm.process(message, (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    private StateMachineV40 getBoltStateMachineInFailedState() throws BoltConnectionFatality {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachine();
        RunMessage runMessage = (RunMessage)Mockito.mock(RunMessage.class);
        Mockito.when((Object)runMessage.databaseName()).thenReturn((Object)"");
        Mockito.when((Object)runMessage.statement()).thenThrow(new Throwable[]{new RuntimeException("error here")});
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)runMessage, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.General.UnknownError);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(FailedState.class);
        return machine;
    }

    private static Stream<RequestMessage> ignoredMessages() {
        return Stream.of(BoltV40Messages.discard((long)2L), BoltV40Messages.pull((long)2L), BoltV40Messages.run((String)"A cypher query"), BoltV40Messages.rollback(), BoltV40Messages.commit());
    }

    private static Stream<RequestMessage> illegalV4Messages() {
        return Stream.of(BoltV40Messages.hello(), BoltV40Messages.begin(), BoltV40Messages.goodbye());
    }
}

