/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.v40;

import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.bolt.fsm.v40.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.Signal;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v40.fsm.AutoCommitState;
import org.neo4j.bolt.protocol.v40.fsm.FailedState;
import org.neo4j.bolt.protocol.v40.fsm.InTransactionState;
import org.neo4j.bolt.protocol.v40.fsm.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.protocol.v40.messaging.request.BeginMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.virtual.MapValue;

class ReadyStateIT
extends BoltStateMachineV4StateTestBase {
    ReadyStateIT() {
    }

    @Test
    void shouldMoveToAutoCommitOnRun_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachine();
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage("CREATE (n {k:'k'}) RETURN n.k", EMPTY_PARAMS), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("fields").containsKey("t_first"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(AutoCommitState.class);
    }

    @Test
    void shouldMoveToInTransactionOnBegin_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachine();
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new BeginMessage(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
    }

    @Test
    void shouldMoveToInterruptedOnInterrupt() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachine();
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)Signal.INTERRUPT, (ResponseHandler)recorder);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InterruptedState.class);
    }

    @Test
    void shouldMoveToFailedStateOnRun_fail() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachine();
        RunMessage runMessage = (RunMessage)Mockito.mock(RunMessage.class);
        Mockito.when((Object)runMessage.databaseName()).thenReturn((Object)"");
        Mockito.when((Object)runMessage.statement()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)runMessage, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.General.UnknownError);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(FailedState.class);
    }

    @Test
    void shouldMoveToFailedStateOnBegin_fail() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachine();
        BeginMessage beginMessage = (BeginMessage)Mockito.mock(BeginMessage.class);
        Mockito.when((Object)beginMessage.databaseName()).thenReturn((Object)"");
        Mockito.when((Object)beginMessage.bookmarks()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)beginMessage, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.General.UnknownError);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(FailedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV3Messages(RequestMessage message) throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachine();
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        StateMachineAssertions.assertThat((StateMachine)machine).shouldKillConnection(fsm -> fsm.process(message, (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    private static Stream<RequestMessage> illegalV4Messages() throws BoltIOException {
        return Stream.of(BoltV40Messages.hello(), BoltV40Messages.pull(), BoltV40Messages.discard(), BoltV40Messages.commit(), BoltV40Messages.rollback(), BoltV40Messages.goodbye());
    }
}

