/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.v40;

import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.fsm.v40.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.protocol.common.message.response.SuccessMessage;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.assertions.AnyValueAssertions;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.bolt.testing.response.RecordedMessage;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class TransactionIT
extends BoltStateMachineV4StateTestBase {
    private static final Pattern BOOKMARK_PATTERN = Pattern.compile("\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b:[0-9]+");

    TransactionIT() {
    }

    @Test
    void shouldHandleBeginCommit() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.run((String)"CREATE (n:InTx)"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.discard(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.commit(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(3);
    }

    @Test
    void shouldHandleBeginRollback() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.run((String)"CREATE (n:InTx)"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.discard(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.rollback(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(3);
    }

    @Test
    void shouldFailWhenOutOfOrderRollbackInAutoCommitMode() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        org.junit.jupiter.api.Assertions.assertThrows(BoltProtocolBreachFatality.class, () -> machine.process(BoltV40Messages.rollback(), (ResponseHandler)NullResponseHandler.nullResponseHandler()));
    }

    @Test
    void shouldFailWhenOutOfOrderCommitInAutoCommitMode() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        org.junit.jupiter.api.Assertions.assertThrows(BoltProtocolBreachFatality.class, () -> machine.process(BoltV40Messages.commit(), (ResponseHandler)NullResponseHandler.nullResponseHandler()));
    }

    @Test
    void shouldReceiveBookmarkOnCommit() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"CREATE (a:Person)"), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.discard(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.commit(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("bookmark", value -> AnyValueAssertions.assertThat((AnyValue)value).asString().matches(BOOKMARK_PATTERN)));
    }

    @Test
    void shouldNotReceiveBookmarkOnRollback() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"CREATE (a:Person)"), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.discard(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.rollback(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark"));
    }

    @Test
    void shouldReadYourOwnWrites() throws Exception {
        String bookmarkPrefix;
        BinaryLatch latch = new BinaryLatch();
        try (StateMachineV40 machine = this.newStateMachineAfterAuth();){
            ResponseRecorder recorder = new ResponseRecorder();
            machine.process(BoltV40Messages.run((String)"CREATE (n:A {prop:'one'})"), (ResponseHandler)NullResponseHandler.nullResponseHandler());
            machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
            RecordedMessage response = recorder.next();
            Assertions.assertThat((boolean)response.isResponse()).isTrue();
            ResponseMessage msg = response.asResponse();
            Assertions.assertThat((Object)msg).isInstanceOf(SuccessMessage.class);
            String bookmark = ((TextValue)((SuccessMessage)msg).meta().get("bookmark")).stringValue();
            bookmarkPrefix = bookmark.split(":")[0];
        }
        long dbVersion = env.lastClosedTxId();
        Thread thread = new Thread(() -> {
            try (StateMachineV40 machine = this.newStateMachineAfterAuth();){
                latch.await();
                ResponseRecorder recorder = new ResponseRecorder();
                machine.process(BoltV40Messages.run((String)"MATCH (n:A) SET n.prop = 'two'", (MapValue)VirtualValues.EMPTY_MAP), (ResponseHandler)NullResponseHandler.nullResponseHandler());
                machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
            }
            catch (Throwable connectionFatality) {
                throw new RuntimeException(connectionFatality);
            }
        });
        thread.start();
        long dbVersionAfterWrite = dbVersion + 1L;
        try (StateMachineV40 machine = this.newStateMachineAfterAuth();){
            ResponseRecorder recorder = new ResponseRecorder();
            latch.release();
            TextValue bookmark = Values.stringValue((String)(bookmarkPrefix + ":" + dbVersionAfterWrite));
            machine.process(BoltV40Messages.begin((DatabaseIdRepository)env.databaseIdRepository(), (ListValue)VirtualValues.list((AnyValue[])new AnyValue[]{bookmark})), (ResponseHandler)recorder);
            machine.process(BoltV40Messages.run((String)"MATCH (n:A) RETURN n.prop"), (ResponseHandler)recorder);
            machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
            machine.process(BoltV40Messages.commit(), (ResponseHandler)recorder);
            ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(2).hasRecord(new AnyValue[]{Values.stringValue((String)"two")}).hasSuccessResponse().hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("bookmark", value -> AnyValueAssertions.assertThat((AnyValue)value).asString().matches(BOOKMARK_PATTERN)));
        }
        thread.join();
    }

    @Test
    void shouldAllowNewRunAfterRunFailure() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        ResponseRecorder recorder = new ResponseRecorder();
        machine.process(BoltV40Messages.run((String)"INVALID QUERY"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        TransactionIT.resetReceived((StateMachine)machine, recorder);
        machine.process(BoltV40Messages.run((String)"RETURN 2", (MapValue)VirtualValues.EMPTY_MAP), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Statement.SyntaxError).hasIgnoredResponse().hasSuccessResponse(2).hasRecord(new AnyValue[]{Values.longValue((long)2L)}).hasSuccessResponse().hasNoRemainingResponses();
    }

    @Test
    void shouldAllowNewRunAfterStreamingFailure() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        ResponseRecorder recorder = new ResponseRecorder();
        machine.process(BoltV40Messages.run((String)"UNWIND [1, 0] AS x RETURN 1 / x"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        TransactionIT.resetReceived((StateMachine)machine, recorder);
        machine.process(BoltV40Messages.run((String)"RETURN 2"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse().hasRecord(new AnyValue[]{Values.longValue((long)1L)}).hasFailureResponse((Status)Status.Statement.ArithmeticError).hasSuccessResponse(2).hasRecord(new AnyValue[]{Values.longValue((long)2L)}).hasSuccessResponse().hasNoRemainingResponses();
    }

    @Test
    void shouldNotAllowNewRunAfterRunFailure() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        ResponseRecorder recorder = new ResponseRecorder();
        machine.process(BoltV40Messages.run((String)"INVALID QUERY"), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.pull(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run(), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse(2).hasNoRemainingResponses();
    }

    @Test
    void shouldNotAllowNewRunAfterStreamingFailure() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        ResponseRecorder recorder = new ResponseRecorder();
        machine.process(BoltV40Messages.run((String)"UNWIND [1, 0] AS x RETURN 1 / x"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.run(), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse().hasRecord(new AnyValue[]{Values.longValue((long)1L)}).hasFailureResponse((Status)Status.Statement.ArithmeticError).hasIgnoredResponse(2).hasNoRemainingResponses();
    }

    @Test
    void shouldNotAllowNewTransactionAfterProtocolFailure() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        StateMachineAssertions.assertThat((StateMachine)machine).shouldKillConnection(fsm -> fsm.process(BoltV40Messages.commit(), (ResponseHandler)NullResponseHandler.nullResponseHandler())).isInInvalidState();
    }

    private static void resetReceived(StateMachine machine, ResponseRecorder recorder) throws BoltConnectionFatality {
        machine.connection().interrupt();
        machine.interrupt();
        machine.process(BoltV40Messages.reset(), (ResponseHandler)recorder);
    }
}

