/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.streaming;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltV44Wire;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.testing.PackstreamBufAssertions;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.virtual.MapValueBuilder;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@IncludeWire(value={@Version(major=4)})
public class LegacyStreamingIT {
    private static void assertLegacyNode(PackstreamBuf buf, long nodeId, String label, Consumer<Map<String, Object>> propertyAssertions) {
        PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsStruct(78, 3L).containsInt(nodeId).containsList(labels -> Assertions.assertThat((List)labels).containsExactly(new Object[]{label})).containsMap(propertyAssertions);
    }

    @ProtocolTest
    void shouldReturnLegacyIdForNodes(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CREATE (m:Movie{title:\"The Matrix\"}) RETURN m")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().packstreamSatisfies(stream -> ((PackstreamBufAssertions)stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).satisfies(buf -> LegacyStreamingIT.assertLegacyNode(buf, 0L, "Movie", properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"title", (Object)"The Matrix")))).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    private static void assertLegacyIdRelationship(PackstreamBuf buf, Consumer<PackstreamBuf> nodeIdAssertions) {
        ((PackstreamBufAssertions)PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsInt(0L).satisfies(nodeIdAssertions)).containsString("PLAYED_IN").containsMap(properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"year", (Object)2021L));
    }

    @ProtocolTest
    void shouldReturnLegacyIdForRelationships(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CREATE (:Actor{name: \"Greg\"})-[r:PLAYED_IN{year: 2021}]->(:Movie{title:\"The Matrix\"}) RETURN r")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().packstreamSatisfies(stream -> ((PackstreamBufAssertions)stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(82, 5L).satisfies(buf -> LegacyStreamingIT.assertLegacyIdRelationship(buf, b -> PackstreamBufAssertions.assertThat((PackstreamBuf)b).containsInt(0L).containsInt(1L)))).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    void shouldReturnLegacyIdForPaths(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CREATE p=(:Actor{name: \"Greg\"})-[:PLAYED_IN{year: 2021}]->(:Movie{title:\"The Matrix\"}) RETURN p")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().packstreamSatisfies(stream -> ((PackstreamBufAssertions)((PackstreamBufAssertions)((PackstreamBufAssertions)stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(80, 3L).containsListHeader(2L).satisfies(buf -> LegacyStreamingIT.assertLegacyNode(buf, 0L, "Actor", properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"name", (Object)"Greg")))).satisfies(buf -> LegacyStreamingIT.assertLegacyNode(buf, 1L, "Movie", properties -> ((MapAssert)Assertions.assertThat((Map)properties).hasSize(1)).containsEntry((Object)"title", (Object)"The Matrix")))).containsListHeader(1L).containsStruct(114, 3L).satisfies(buf -> LegacyStreamingIT.assertLegacyIdRelationship(buf, b -> {}))).containsList(indices -> Assertions.assertThat((List)indices).containsExactly(new Object[]{1L, 1L})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    void shouldNegotiateUTCPatch(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        wire.enable(new Feature[]{Feature.UTC_DATETIME});
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"patch_bolt", List.of(Feature.UTC_DATETIME.getId())));
    }

    @ProtocolTest
    void shouldAcceptLegacyOffsetDateTimes(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        DateTimeValue input = DateTimeValue.datetime((OffsetDateTime)OffsetDateTime.of(1995, 6, 14, 12, 50, 35, 556000000, ZoneOffset.ofHours(1)));
        MapValueBuilder params = new MapValueBuilder();
        params.add("input", (AnyValue)input);
        connection.send(wire.run("RETURN $input", params.build())).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().packstreamSatisfies(stream -> stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(70, 3L).containsInt(803134235L).containsInt(556000000L).containsInt(3600L).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    void shouldAcceptLegacyZoneDateTimes(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("RETURN datetime('1995-06-14T12:50:35.556+02:00[Europe/Berlin]')")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().packstreamSatisfies(stream -> stream.receivesMessage().containsStruct(113, 1L).containsListHeader(1L).containsStruct(102, 3L).containsInt(803134235L).containsInt(556000000L).containsString("Europe/Berlin").asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    void shouldNotAcceptUTCDatesWithoutPatch(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        wire.enable(new Feature[]{Feature.UTC_DATETIME});
        DateTimeValue input = DateTimeValue.datetime((OffsetDateTime)OffsetDateTime.of(1995, 6, 14, 12, 50, 35, 556000000, ZoneOffset.ofHours(1)));
        MapValueBuilder params = new MapValueBuilder();
        params.add("input", (AnyValue)input);
        BoltV44Wire utcEnabledWire = new BoltV44Wire();
        utcEnabledWire.enable(new Feature[]{Feature.UTC_DATETIME});
        connection.send(utcEnabledWire.run("RETURN $input", params.build()));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }
}

