/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.connection.transport.DefaultTransportSelector;
import org.neo4j.bolt.test.connection.transport.TransportSelector;
import org.neo4j.bolt.test.extension.BoltTestConfig;
import org.neo4j.bolt.test.wire.initializer.BoltWireInitializer;
import org.neo4j.bolt.test.wire.selector.BoltWireSelector;
import org.neo4j.bolt.test.wire.selector.DefaultBoltWireSelector;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public final class BoltTestSupportExtension
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Optional<Class> supportAnnotation = context.getTestMethod().flatMap(method -> AnnotationSupport.findAnnotation((AnnotatedElement)method, BoltTestExtension.class)).or(() -> context.getTestClass().flatMap(type -> AnnotationSupport.findAnnotation((AnnotatedElement)type, BoltTestExtension.class)));
        Class databaseFactoryType = supportAnnotation.map(BoltTestExtension::databaseManagementServiceBuilder).filter(type -> BoltTestExtension.PlaceholderTestDatabaseManagementServiceBuilder.class != type).orElseGet(() -> this.getDefaultDatabaseFactoryType());
        Method factoryFunction = this.getFactoryFunction(context);
        Method settingsFunction = this.getSettingsFunction(context);
        return this.getTransportTypes(context).flatMap(transportType -> this.getWires(context).map(wire -> this.configure(context, databaseFactoryType, factoryFunction, settingsFunction, (TransportType)transportType, (BoltWire)wire)));
    }

    protected BoltTestConfig configure(ExtensionContext context, Class<? extends TestDatabaseManagementServiceBuilder> databaseFactoryType, Method factoryFunction, Method settingsFunction, TransportType transportType, BoltWire wire) {
        return new BoltTestConfig(databaseFactoryType, factoryFunction, settingsFunction, transportType, wire);
    }

    protected static Optional<Method> findMethod(Class<?> type, Class<? extends Annotation> annotationType) {
        List methods = AnnotationSupport.findAnnotatedMethods(type, annotationType, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        if (methods.isEmpty()) {
            return Optional.empty();
        }
        if (methods.size() != 1) {
            Assertions.fail((String)("Illegal test configuration: Only one method may be annotated with @" + annotationType.getSimpleName() + ": " + methods.size() + " were found"));
        }
        return Optional.of((Method)methods.get(0));
    }

    protected Method getFactoryFunction(ExtensionContext context) {
        Method method = context.getTestClass().flatMap(type -> BoltTestSupportExtension.findMethod(type, FactoryFunction.class)).orElse(null);
        if (method == null) {
            return null;
        }
        Assertions.assertFalse((method.getParameterCount() > 1 ? 1 : 0) != 0, (String)("Method annotated with @" + FactoryFunction.class.getSimpleName() + " is invalid: Must accept zero or one parameters"));
        if (method.getParameterCount() == 1) {
            Assertions.assertTrue((boolean)TestDatabaseManagementServiceBuilder.class.isAssignableFrom(method.getParameterTypes()[0]), (String)("Method annotated with @" + FactoryFunction.class.getSimpleName() + " is invalid: Parameter must be " + TestDatabaseManagementServiceBuilder.class.getSimpleName() + " or one of its children"));
        } else {
            Assertions.assertTrue((boolean)TestDatabaseManagementServiceBuilder.class.isAssignableFrom(method.getReturnType()), (String)("Method annotated with @" + FactoryFunction.class.getSimpleName() + " is invalid: Return type must be " + TestDatabaseManagementServiceBuilder.class.getSimpleName() + " or one of its children"));
        }
        return method;
    }

    protected Method getSettingsFunction(ExtensionContext context) {
        Method method = context.getTestClass().flatMap(type -> BoltTestSupportExtension.findMethod(type, SettingsFunction.class)).orElse(null);
        if (method == null) {
            return null;
        }
        Assertions.assertFalse((method.getParameterCount() > 1 ? 1 : 0) != 0, (String)("Method annotated with @" + SettingsFunction.class.getSimpleName() + " is invalid: Must accept one parameter"));
        Assertions.assertEquals(Map.class, method.getParameterTypes()[0], (String)("Method annotated with @" + SettingsFunction.class.getSimpleName() + " is invalid: Parameter must be Map<" + Setting.class + "<?>, Object>"));
        return method;
    }

    protected Class<? extends TestDatabaseManagementServiceBuilder> getDefaultDatabaseFactoryType() {
        return TestDatabaseManagementServiceBuilder.class;
    }

    protected Stream<BoltWire> getWires(ExtensionContext context) {
        BoltWireSelector selector = BoltWireSelector.findSelector(context).orElseGet(DefaultBoltWireSelector::new);
        List<BoltWireInitializer> initializers = BoltWireInitializer.findInitializer(context);
        return selector.select(context).peek(wire -> initializers.forEach(initializer -> initializer.initialize(context, (BoltWire)wire)));
    }

    protected Stream<TransportType> getTransportTypes(ExtensionContext context) {
        TransportSelector selector = TransportSelector.findSelector(context).orElseGet(DefaultTransportSelector::new);
        return selector.select(context);
    }
}

