/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.lifecycle;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketSupportExtension;

public class ServerInstanceManager
implements BeforeEachCallback,
AfterEachCallback {
    private final BiConsumer<ExtensionContext, Neo4jWithSocket> serverInitializer;

    public ServerInstanceManager(BiConsumer<ExtensionContext, Neo4jWithSocket> serverInitializer) {
        this.serverInitializer = serverInitializer;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Neo4jWithSocket server = Neo4jWithSocketSupportExtension.getInstance((ExtensionContext)context);
        this.serverInitializer.accept(context, server);
        server.init((TestInfo)new BoltTestInfo(context));
    }

    public void afterEach(ExtensionContext context) {
        Neo4jWithSocket server = Neo4jWithSocketSupportExtension.getInstance((ExtensionContext)context);
        server.shutdownDatabase();
    }

    private static class BoltTestInfo
    implements TestInfo {
        private final String displayName;
        private final Set<String> tags;
        private final Optional<Class<?>> testClass;
        private final Optional<Method> testMethod;

        private BoltTestInfo(ExtensionContext context) {
            this.displayName = context.getDisplayName();
            this.tags = context.getTags();
            this.testClass = context.getTestClass();
            this.testMethod = context.getTestMethod();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public Optional<Class<?>> getTestClass() {
            return this.testClass;
        }

        public Optional<Method> getTestMethod() {
            return this.testMethod;
        }
    }
}

