/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.throttle;

import java.net.SocketException;
import java.net.StandardSocketOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.protocol.common.handler.HouseKeeperHandler;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.transport.ExcludeTransport;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@Disabled
@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class WriteThrottleTimeoutIT {
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    @Inject
    private OtherThread otherThread;

    @FactoryFunction
    void customizeDatabase(TestDatabaseManagementServiceBuilder factory) {
        factory.setInternalLogProvider((InternalLogProvider)this.internalLogProvider);
    }

    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_high_water_mark, (int)ByteUnit.kibiBytes((long)64L));
        settings.put(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_low_water_mark, (int)ByteUnit.kibiBytes((long)16L));
        settings.put(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_max_duration, Duration.ofSeconds(30L));
    }

    @BeforeEach
    void prepare() {
        this.otherThread.set(5L, TimeUnit.MINUTES);
    }

    @AfterEach
    void cleanup() {
        this.internalLogProvider.clear();
    }

    @TransportTest
    @ExcludeTransport(value={TransportType.WEBSOCKET, TransportType.WEBSOCKET_TLS})
    void sendingButNotReceivingClientShouldBeKilledWhenWriteThrottleMaxDurationIsReached(BoltWire wire, @Authenticated TransportConnection connection) {
        String largeString = " ".repeat((int)ByteUnit.kibiBytes((long)64L));
        connection.setOption(StandardSocketOptions.SO_RCVBUF, (Object)((int)ByteUnit.kibiBytes((long)32L)));
        Future sender = this.otherThread.execute(() -> {
            while (!Thread.interrupted()) {
                connection.send(wire.run("RETURN $data as data", ValueUtils.asMapValue(Collections.singletonMap("data", largeString)))).send(wire.pull());
            }
            return null;
        });
        Assertions.assertThatExceptionOfType(ExecutionException.class).isThrownBy(() -> this.otherThread.get().awaitFuture(sender)).withRootCauseInstanceOf(SocketException.class);
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(HouseKeeperHandler.class).forLevel(AssertableLogProvider.Level.ERROR).assertExceptionForLogMessage("Fatal error occurred when handling a client connection").hasStackTraceContaining("Outbound network buffer has failed to flush within mandated period of");
    }
}

