/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.provider.ConnectionProvider;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class ConcurrentAccessIT {
    private static final int NUM_WORKERS = 5;
    private static final int NUM_REQUESTS = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWorkload(ConnectionProvider connectionProvider, int nWorkers, int nTimes, ThrowingConsumer<TransportConnection, IOException> workload) throws InterruptedException, BrokenBarrierException, TimeoutException {
        ExecutorService pool = Executors.newFixedThreadPool(nWorkers);
        try {
            CyclicBarrier barrier = new CyclicBarrier(nWorkers + 1);
            AtomicInteger errorCounter = new AtomicInteger();
            for (int i = 0; i < nWorkers; ++i) {
                pool.submit(() -> {
                    try {
                        TransportConnection connection = connectionProvider.create();
                        barrier.await();
                        for (int j = 0; j < nTimes; ++j) {
                            workload.accept((Object)connection);
                        }
                        barrier.await();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        errorCounter.incrementAndGet();
                    }
                });
            }
            barrier.await(1L, TimeUnit.MINUTES);
            barrier.await(1L, TimeUnit.MINUTES);
            Assertions.assertThat((AtomicInteger)errorCounter).hasValue(0);
        }
        finally {
            pool.shutdownNow();
            pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    @ProtocolTest
    void shouldRunSimpleStatement(@Authenticated ConnectionProvider connectionProvider, BoltWire wire) throws Exception {
        this.runWorkload(connectionProvider, 5, 1000, (ThrowingConsumer<TransportConnection, IOException>)((ThrowingConsumer)connection -> {
            connection.send(wire.begin()).send(wire.run("CREATE (n)")).send(wire.pull()).send(wire.rollback());
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_first", "qid"}).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).isEmpty())).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_last", "db"})).receivesSuccess();
            connection.send(wire.run("MATCH (n) RETURN n")).send(wire.pull());
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_first"}).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"n"}))).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_last", "db"}));
        }));
    }
}

