/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.util.ServerUtil;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class PreAuthLimitIT {
    private static final String EXCEEDED_LIMIT_MESSAGE = "Value of size 1023 exceeded limit of 1000";
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    @Inject
    private Neo4jWithSocket server;

    @FactoryFunction
    void customizeDatabase(TestDatabaseManagementServiceBuilder factory) {
        factory.setInternalLogProvider((InternalLogProvider)this.internalLogProvider);
    }

    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes, 1000L);
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_timeout, Duration.ofSeconds(2L));
    }

    @BeforeEach
    void prepare() throws ProcedureException {
        ServerUtil.installSleepProcedure(this.server);
    }

    @AfterEach
    void cleanup() {
        this.internalLogProvider.clear();
    }

    @ProtocolTest
    void shouldFailDueToMessageBeingTooLargeInUnauthenticatedState(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(this.createValidBufferOf1023bytes((short)1));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, EXCEEDED_LIMIT_MESSAGE).isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void shouldFailDueToMessageBeingTooLargeInAuthenticationState(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(this.createValidBufferOf1023bytes((short)1));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, EXCEEDED_LIMIT_MESSAGE).isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void shouldFailDueToMessageBeingTooLargeInAuthenticationStateAfterLoggingOut(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.logoff());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(this.createValidBufferOf1023bytes((short)1));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, EXCEEDED_LIMIT_MESSAGE).isEventuallyTerminated();
    }

    @ProtocolTest
    void whenAuthenticatedShouldBeNoLimitOnMessageSize(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(this.createValidBufferOf1023bytes((short)17));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    private PackstreamBuf createValidBufferOf1023bytes(short messageTag) {
        PackstreamBuf buff = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, messageTag)).writeMapHeader(1L).writeString("user_agent").writeString("test/1").writeString("2");
        for (int i = 0; i < 500; ++i) {
            buff.writeInt8((byte)1);
        }
        return buff;
    }

    @ProtocolTest
    void whenInUnauthenticatedStateShouldErrorIfConnectionOpenTooLong(BoltWire wire, @Negotiated TransportConnection connection) throws IOException, InterruptedException {
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
        Thread.sleep(1000L);
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.ERROR).containsMessagesEventually(Duration.ofSeconds(4L).toMillis(), new String[]{"as the client failed to authenticate within 2000 ms."});
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void whenInAuthenticationStateShouldErrorIfConnectionOpenTooLong(BoltWire wire, @Negotiated TransportConnection connection) throws IOException, InterruptedException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.ERROR).containsMessagesEventually(Duration.ofSeconds(4L).toMillis(), new String[]{"as the server failed to handle an authentication request within 2000 ms."});
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void whenInAuthenticationStateAfterLogoffShouldErrorIfConnectionOpenTooLong(BoltWire wire, @Authenticated TransportConnection connection) throws IOException, InterruptedException {
        connection.send(wire.logoff());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forLevel(AssertableLogProvider.Level.ERROR).containsMessagesEventually(Duration.ofSeconds(4L).toMillis(), new String[]{"as the client failed to authenticate within 2000 ms."});
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void whenLoggedInShouldBeNoAuthenticationTimout(BoltWire wire, @Negotiated TransportConnection connection) throws IOException, InterruptedException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        Thread.sleep(Duration.ofSeconds(5L).toMillis());
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }
}

