/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.util.List;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.state.InterruptedState;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.fsm.state.FailedState;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.annotation.fsm.initializer.Failed;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;

@CommunityStateMachineTestExtension
class FailedStateIT {
    FailedStateIT() {
    }

    @StateMachineTest
    void shouldIgnoreMessages(@Failed StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        List<RequestMessage> candidates = List.of(messages.discard(2L), messages.pull(2L), messages.run("A cypher query"), messages.rollback(), messages.commit());
        for (RequestMessage message : candidates) {
            fsm.process(message, (ResponseHandler)recorder);
            ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
            StateMachineAssertions.assertThat((StateMachine)fsm).isInState(FailedState.class);
        }
    }

    @StateMachineTest
    void shouldMoveToInterruptedOnInterruptSignal(@Failed StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws BoltConnectionFatality {
        fsm.connection().interrupt();
        fsm.process(messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(InterruptedState.class);
    }

    @StateMachineTest
    void shouldTerminateConnectionOnHello(@Failed StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) {
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(machine -> machine.process(messages.hello(), (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    @StateMachineTest
    void shouldTerminateConnectionOnBegin(@Failed StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) {
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(machine -> machine.process(messages.begin(), (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    @StateMachineTest
    void shouldTerminateConnectionOnGoodbye(@Failed StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) {
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(machine -> machine.process(messages.goodbye(), (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }
}

