/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.mockito.Mockito;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.state.InterruptedState;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.transaction.BeginMessage;
import org.neo4j.bolt.protocol.common.message.request.transaction.RunMessage;
import org.neo4j.bolt.protocol.v40.fsm.state.AutoCommitState;
import org.neo4j.bolt.protocol.v40.fsm.state.FailedState;
import org.neo4j.bolt.protocol.v40.fsm.state.InTransactionState;
import org.neo4j.bolt.protocol.v51.fsm.state.AuthenticationState;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.annotation.fsm.initializer.Authenticated;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.virtual.MapValue;

@CommunityStateMachineTestExtension
class ReadyStateIT {
    ReadyStateIT() {
    }

    @StateMachineTest
    void shouldMoveToInterruptedOnInterrupt(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws BoltConnectionFatality {
        fsm.connection().interrupt();
        fsm.process(messages.run("RETURN 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(InterruptedState.class);
    }

    private void shouldCloseConnectionOnMessage(StateMachine fsm, RequestMessage message) {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(it -> it.process(message, (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
        StateMachineAssertions.assertThat((StateMachine)fsm).isInInvalidState();
    }

    @StateMachineTest
    void shouldCloseConnectionOnPull(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.pull());
    }

    @StateMachineTest
    void shouldCloseConnectionOnDiscard(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.discard());
    }

    @StateMachineTest
    void shouldCloseConnectionOnCommit(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.commit());
    }

    @StateMachineTest
    void shouldCloseConnectionOnRollback(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.rollback());
    }

    @StateMachineTest
    void shouldCloseConnectionOnGoodbye(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.goodbye());
    }

    @StateMachineTest
    void shouldMoveToAutoCommitOnRun_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.run("CREATE (n {k:'k'}) RETURN n.k"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("fields").containsKey("t_first"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(AutoCommitState.class);
    }

    @StateMachineTest
    void shouldMoveToInTransactionOnBegin_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.begin(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(InTransactionState.class);
    }

    @StateMachineTest
    void shouldMoveToFailedStateOnRun_fail(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        RunMessage runMessage = (RunMessage)Mockito.mock(RunMessage.class);
        Mockito.when((Object)runMessage.databaseName()).thenReturn(null);
        Mockito.when((Object)runMessage.statement()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        fsm.process((RequestMessage)runMessage, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.General.UnknownError);
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(FailedState.class);
    }

    @StateMachineTest
    void shouldMoveToFailedStateOnBegin_fail(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        BeginMessage beginMessage = (BeginMessage)Mockito.mock(BeginMessage.class);
        Mockito.when((Object)beginMessage.databaseName()).thenReturn(null);
        Mockito.when((Object)beginMessage.bookmarks()).thenThrow(new Throwable[]{new RuntimeException("Fail")});
        fsm.process((RequestMessage)beginMessage, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.General.UnknownError);
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(FailedState.class);
    }

    @StateMachineTest(since=@Version(major=5, minor=1))
    void shouldMoveBackToAuthenticationStateAfterALogoffMessage(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws BoltConnectionFatality {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        fsm.process(messages.logon(), (ResponseHandler)recorder);
        fsm.process(messages.logoff(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(AuthenticationState.class);
    }
}

