/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.dependency;

import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.security.basic.BasicAuthentication;
import org.neo4j.bolt.test.extension.db.ServerInstanceContext;
import org.neo4j.bolt.testing.extension.dependency.StateMachineDependencyProvider;
import org.neo4j.bolt.testing.mock.ConnectionMockFactory;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketSupportExtension;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.bolt.tx.TransactionManagerImpl;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.time.SystemNanoClock;

public class CommunityEditionStateMachineDependencyProvider
implements StateMachineDependencyProvider {
    private final ServerInstanceContext instanceContext;
    private String defaultDatabase;
    private Authentication authentication;
    private TransactionManager transactionManager;

    public CommunityEditionStateMachineDependencyProvider(ExtensionContext context) {
        this(TestDatabaseManagementServiceBuilder.class, context);
    }

    protected CommunityEditionStateMachineDependencyProvider(Class<? extends TestDatabaseManagementServiceBuilder> defaultTestDatabaseManagementServiceBuilder, ExtensionContext context) {
        this.instanceContext = ServerInstanceContext.forExtensionContext(context, defaultTestDatabaseManagementServiceBuilder, Collections.emptyList(), Collections.emptyList());
    }

    private GraphDatabaseAPI getDatabaseAPI(ExtensionContext ctx) {
        Neo4jWithSocket neo4j = Neo4jWithSocketSupportExtension.getInstance((ExtensionContext)ctx);
        return (GraphDatabaseAPI)neo4j.graphDatabaseService();
    }

    public BoltGraphDatabaseManagementServiceSPI spi(ExtensionContext ctx) {
        GraphDatabaseAPI gdb = this.getDatabaseAPI(ctx);
        return (BoltGraphDatabaseManagementServiceSPI)gdb.getDependencyResolver().resolveDependency(BoltGraphDatabaseManagementServiceSPI.class);
    }

    public SystemNanoClock clock(ExtensionContext ctx) {
        GraphDatabaseAPI gdb = this.getDatabaseAPI(ctx);
        return (SystemNanoClock)gdb.getDependencyResolver().resolveDependency(SystemNanoClock.class);
    }

    public Connection connection(ExtensionContext ctx) {
        return (Connection)ConnectionMockFactory.newFactory((String)"bolt-test").withSelectedDefaultDatabase(this.defaultDatabase).withAuthentication(this.authentication).withConnector(connector -> connector.withTransactionManager(this.transactionManager)).withTransactionManager(this.transactionManager).withInterruptedCaptor(new AtomicInteger()).build();
    }

    public Optional<Long> lastTransactionId(ExtensionContext ctx) {
        GraphDatabaseAPI gdb = this.getDatabaseAPI(ctx);
        return Optional.of(((TransactionIdStore)gdb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId());
    }

    public void init(ExtensionContext context, TestInfo testInfo) {
        Neo4jWithSocket neo4j = this.instanceContext.configure(context);
        try {
            neo4j.init(testInfo);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to initialize server", ex);
        }
        GraphDatabaseAPI gdb = (GraphDatabaseAPI)neo4j.graphDatabaseService();
        DependencyResolver dependencyResolver = gdb.getDependencyResolver();
        BoltGraphDatabaseManagementServiceSPI spi = (BoltGraphDatabaseManagementServiceSPI)dependencyResolver.resolveDependency(BoltGraphDatabaseManagementServiceSPI.class);
        SystemNanoClock clock = (SystemNanoClock)dependencyResolver.resolveDependency(SystemNanoClock.class);
        AuthManager authManager = (AuthManager)dependencyResolver.resolveDependency(AuthManager.class);
        this.defaultDatabase = (String)((Config)dependencyResolver.resolveDependency(Config.class)).get(GraphDatabaseSettings.initial_default_database);
        this.authentication = new BasicAuthentication(authManager);
        this.transactionManager = new TransactionManagerImpl(spi, (Clock)clock);
    }

    public void close(ExtensionContext context) {
        this.instanceContext.stop(context);
        Mockito.framework().clearInlineMocks();
    }
}

