/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tls;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.jcajce.JcaBasicOCSPRespBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.transport.IncludeTransport;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.client.tls.CertConfiguredSecureSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.CommonConnectorConfig;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.pki.PkiUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.ssl.CertificateChainFactory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@TestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
class OcspStaplingIT {
    private Server server;
    private static Path endUserCertFile;
    private Path endUserKeyFile;
    private Path intCertFile;
    private static Path intKeyFile;
    private Path rootCertFile;
    private static Path rootKeyFile;
    private X509Certificate certificate;
    @Inject
    private FileSystemAbstraction fileSystem;

    OcspStaplingIT() {
    }

    @BeforeAll
    void prepare() throws Exception {
        endUserCertFile = Files.createTempFile("end_key", "pem", new FileAttribute[0]);
        this.endUserKeyFile = Files.createTempFile("end_key", "pem", new FileAttribute[0]);
        this.intCertFile = Files.createTempFile("int_key", "pem", new FileAttribute[0]);
        intKeyFile = Files.createTempFile("int_key", "pem", new FileAttribute[0]);
        this.rootCertFile = Files.createTempFile("root_key", "pem", new FileAttribute[0]);
        rootKeyFile = Files.createTempFile("root_key", "pem", new FileAttribute[0]);
        this.server = OcspStaplingIT.startMockOCSPResponder();
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        CertificateChainFactory.createCertificateChain((Path)endUserCertFile, (Path)this.endUserKeyFile, (Path)this.intCertFile, (Path)intKeyFile, (Path)this.rootCertFile, (Path)rootKeyFile, (int)this.server.getURI().getPort(), (BouncyCastleProvider)bouncyCastleProvider);
        X509Certificate[] certificates = PkiUtils.loadCertificates((FileSystemAbstraction)this.fileSystem, (Path)this.rootCertFile);
        Assertions.assertThat((int)certificates.length).isEqualTo(1);
        this.certificate = certificates[0];
    }

    @AfterAll
    void cleanup() throws IOException {
        Files.deleteIfExists(this.endUserKeyFile);
        Files.deleteIfExists(endUserCertFile);
        Files.deleteIfExists(rootKeyFile);
        Files.deleteIfExists(this.rootCertFile);
        Files.deleteIfExists(intKeyFile);
        Files.deleteIfExists(this.intCertFile);
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SettingsFunction
    void customizeSettings(Map<Setting<?>, Object> settings) {
        SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT);
        settings.put(policy.enabled, true);
        settings.put(policy.public_certificate, endUserCertFile.toAbsolutePath());
        settings.put(policy.private_key, this.endUserKeyFile.toAbsolutePath());
        settings.put(CommonConnectorConfig.ocsp_stapling_enabled, true);
    }

    @TransportTest
    @IncludeTransport(value={TransportType.TCP_TLS})
    void shouldReturnCertificatesWithStapledOcspResponses(HostnamePort address) throws Exception {
        try (CertConfiguredSecureSocketConnection connection = new CertConfiguredSecureSocketConnection(address, this.certificate);){
            connection.connect().sendDefaultProtocolVersion();
            Set certificatesSeen = connection.getServerCertificatesSeen();
            List<BigInteger> certificateSerialNumbersSeen = certificatesSeen.stream().map(X509Certificate::getSerialNumber).toList();
            Assertions.assertThat((Collection)certificatesSeen).hasSize(3);
            Set ocspResponsesSeen = connection.getSeenOcspResponses();
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)ocspResponsesSeen).hasSize(2)).allSatisfy(response -> Assertions.assertThat((Object)response.getResponses()[0]).satisfies(new ThrowingConsumer[]{res -> {
                Assertions.assertThat((Object)res.getCertStatus()).isNull();
                Assertions.assertThat((BigInteger)res.getCertID().getSerialNumber()).isIn((Iterable)certificateSerialNumbersSeen);
            }}));
        }
    }

    private static Server startMockOCSPResponder() throws Exception {
        Server jettyServer = new Server(0);
        ServletHandler handler = new ServletHandler();
        jettyServer.setHandler((Handler)handler);
        jettyServer.setDumpBeforeStop(true);
        handler.addServletWithMapping(EndUserOcspResponderServlet.class, "/endUserCA/*");
        handler.addServletWithMapping(IntOcspResponderServlet.class, "/intCA/*");
        jettyServer.start();
        return jettyServer;
    }

    public static class EndUserOcspResponderServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        private void serveResponse(HttpServletResponse httpResponse) {
            try {
                DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
                X509Certificate[] issueCert = PkiUtils.loadCertificates((FileSystemAbstraction)fs, (Path)endUserCertFile);
                PrivateKey privateKey = PkiUtils.loadPrivateKey((FileSystemAbstraction)fs, (Path)intKeyFile);
                X509CertificateHolder[] certChain = new X509CertificateHolder[]{new X509CertificateHolder(issueCert[0].getEncoded()), new X509CertificateHolder(issueCert[1].getEncoded())};
                DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().build();
                JcaBasicOCSPRespBuilder respGen = new JcaBasicOCSPRespBuilder(issueCert[0].getPublicKey(), digCalcProv.get(RespID.HASH_SHA1));
                CertificateID certificateID = new CertificateID(digCalcProv.get(RespID.HASH_SHA1), certChain[1], issueCert[0].getSerialNumber());
                respGen.addResponse(certificateID, CertificateStatus.GOOD);
                BasicOCSPResp resp = respGen.build(new JcaContentSignerBuilder("SHA256withRSA").build(privateKey), certChain, new Date());
                OCSPRespBuilder rGen = new OCSPRespBuilder();
                OCSPResp ocspResp = rGen.build(0, (Object)resp);
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write(ocspResp.getEncoded());
            }
            catch (Exception e) {
                Assertions.fail((String)"Error whilst responding to intermediate certificates OCSP request");
            }
        }
    }

    public static class IntOcspResponderServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse httpResponse) {
            this.serveResponse(httpResponse);
        }

        private void serveResponse(HttpServletResponse httpResponse) {
            try {
                DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
                X509Certificate[] issueCert = PkiUtils.loadCertificates((FileSystemAbstraction)fs, (Path)endUserCertFile);
                PrivateKey privateKey = PkiUtils.loadPrivateKey((FileSystemAbstraction)fs, (Path)rootKeyFile);
                X509CertificateHolder[] certChain = new X509CertificateHolder[]{new X509CertificateHolder(issueCert[0].getEncoded()), new X509CertificateHolder(issueCert[1].getEncoded()), new X509CertificateHolder(issueCert[2].getEncoded())};
                DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().build();
                JcaBasicOCSPRespBuilder respGen = new JcaBasicOCSPRespBuilder(issueCert[1].getPublicKey(), digCalcProv.get(RespID.HASH_SHA1));
                CertificateID certificateID = new CertificateID(digCalcProv.get(RespID.HASH_SHA1), certChain[2], issueCert[1].getSerialNumber());
                respGen.addResponse(certificateID, CertificateStatus.GOOD);
                BasicOCSPResp resp = respGen.build(new JcaContentSignerBuilder("SHA256withRSA").build(privateKey), certChain, new Date());
                OCSPRespBuilder rGen = new OCSPRespBuilder();
                OCSPResp ocspResp = rGen.build(0, (Object)resp);
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write(ocspResp.getEncoded());
            }
            catch (Exception e) {
                Assertions.fail((String)"Error whilst responding to intermediate certificates OCSP request");
            }
        }
    }
}

