/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BeginBuilder;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.HelloBuilder;
import org.neo4j.bolt.testing.messages.NotificationsMessageBuilder;
import org.neo4j.bolt.testing.messages.RunMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class NotificationsConfigIT {
    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldReturnWarning(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloBuilder)x.withSeverity(NotificationConfiguration.Severity.WARNING)));
        connection.send(wire.logon());
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccessWithNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED, 17, 1, 18);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldReturnSingleCartesianProductWarning(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> {
            x.withDisabledCategories(Set.of(NotificationConfiguration.Category.UNRECOGNIZED));
            return x;
        }));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (n:thisLabelDoesNotExist), (m:thisLabelDoesNotExist) return m, n")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("notifications")).size()).isEqualTo(1));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldReturnSingleUnboundedVariableLengthWarning(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> {
            x.withDisabledCategories(Set.of(NotificationConfiguration.Category.UNRECOGNIZED));
            return x;
        }));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH shortestPath((n:A)-[*]->(m:B)) return m, n")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("notifications")).size()).isEqualTo(1));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldReturnSingleRepeatedRelationshipWarning(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello());
        connection.send(wire.logon());
        connection.send(wire.run("MATCH ()-[r]-()-[r]-() RETURN r AS r")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("notifications")).size()).isEqualTo(1));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldSendFailureWithUnknownSeverity(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloBuilder)x.withUnknownSeverity("WANING")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldSendFailureWithUnknownCategory(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloBuilder)x.withUnknownDisabledCategories(List.of("Pete"))));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldNotReturnNotificationsWhenAllDisabled(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(x -> Assertions.assertThat((Map)x).doesNotContainKey((Object)"notifications"));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldReturnMultipleNotifications(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello());
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (a:Person) CALL { MATCH (a:Label) RETURN a AS aLabel } RETURN a")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(x -> {
            Assertions.assertThat((Map)x).containsKey((Object)"notifications");
            Assertions.assertThat((List)((ArrayList)x.get("notifications"))).hasSize(3);
        });
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldEnableNotificationsForQuery(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(x -> Assertions.assertThat((Map)x).doesNotContainKey((Object)"notifications"));
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)", x -> (RunMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.INFORMATION))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED, 17, 1, 18);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldSendFailureOnRunWithUnknownSeverity(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("RETURN 1 as n", x -> (RunMessageBuilder)x.withUnknownSeverity("boom")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldSendFailureOnRunWithUnknownCategory(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("RETURN 1 as n", x -> (RunMessageBuilder)x.withUnknownDisabledCategories(List.of("boom"))));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldEnableNotificationsForQueryUsingCategories(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(x -> Assertions.assertThat((Map)x).doesNotContainKey((Object)"notifications"));
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)", x -> (RunMessageBuilder)x.withDisabledCategories(Collections.emptyList()))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED, 17, 1, 18);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldEnableNotificationsInBegin(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(x -> Assertions.assertThat((Map)x).doesNotContainKey((Object)"notifications"));
        connection.send(wire.begin(x -> (BeginBuilder)x.withSeverity(NotificationConfiguration.Severity.WARNING)));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED, 17, 1, 18);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldEnableNotificationsInBeginWithCategories(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(x -> Assertions.assertThat((Map)x).doesNotContainKey((Object)"notifications"));
        connection.send(wire.begin(x -> (BeginBuilder)x.withDisabledCategories(Collections.emptyList())));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, NotificationCategory.UNRECOGNIZED, 17, 1, 18);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldNotReturnNotificationsInDisabledCategories(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloBuilder)x.withDisabledCategories(List.of(NotificationConfiguration.Category.GENERIC, NotificationConfiguration.Category.UNRECOGNIZED))));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (a:Person) CALL { MATCH (a:Label) RETURN a AS aLabel } RETURN a")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(x -> Assertions.assertThat((Map)x).doesNotContainKey((Object)"notifications"));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=1, range=1)})
    public void shouldNotReturnNotificationsWhenNotHighEnoughSeverity(BoltWire wire, @Negotiated TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloBuilder)x.withSeverity(NotificationConfiguration.Severity.WARNING)));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (a:Person) CALL { MATCH (a:Label) RETURN a AS aLabel } RETURN a")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(x -> Assertions.assertThat((String)x.get("notifications").toString()).doesNotContain(new CharSequence[]{"GENERIC"}));
    }
}

