/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.assertj.core.api.StringAssert;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.response.NoopResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.annotation.fsm.initializer.Authenticated;
import org.neo4j.bolt.testing.annotation.fsm.initializer.InTransaction;
import org.neo4j.bolt.testing.annotation.fsm.initializer.Streaming;
import org.neo4j.bolt.testing.assertions.AnyValueAssertions;
import org.neo4j.bolt.testing.assertions.ConnectionAssertions;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

@CommunityStateMachineTestExtension
public class InTransactionStateIT {
    @StateMachineTest
    void shouldTransitionToInTransaction(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.begin(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest
    void shouldReturnToReadyOnCommit(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.commit(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("bookmark"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.READY);
    }

    @StateMachineTest
    void shouldReturnToReadyOnRollback(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.rollback(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark").doesNotContainKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.READY);
    }

    @StateMachineTest
    void shouldRemainInStateWhenStatementClosesViaDiscard(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.discard(100L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest
    void shouldIndicateRemainingElementsWhenDiscarding(@Streaming(value="UNWIND [1, 2, 3] AS n RETURN n") StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.discard(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("has_more", (AnyValue)BooleanValue.TRUE).doesNotContainKey("db"));
        fsm.process(messages.discard(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").doesNotContainKey("bookmark").containsKey("db").doesNotContainKey("has_more"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest
    void shouldRemainInStateWhenStatementClosesViaPull(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.pull(100L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord().hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").doesNotContainKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest
    void shouldIndicateRemainingElementsWhenPulling(@Streaming(value="UNWIND [1, 2, 3] AS n RETURN n") StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.pull(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)1L)}).hasRecord(new AnyValue[]{Values.longValue((long)2L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("has_more", (AnyValue)BooleanValue.TRUE).doesNotContainKey("db"));
        fsm.process(messages.pull(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)3L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").doesNotContainKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest
    void shouldSupportMultipleStatements(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.run("MATCH (n) RETURN n LIMIT 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest
    void shouldReceiveBookmarkOnCommit(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.commit(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("bookmark", value -> ((StringAssert)AnyValueAssertions.assertThat((AnyValue)value).asString().isNotEmpty()).isNotBlank()));
    }

    @StateMachineTest
    void shouldNotReceiveBookmarkOnRollback(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.rollback(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark"));
    }

    @StateMachineTest
    void shouldCloseTransactionEvenIfCommitFails(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.begin(), (ResponseHandler)recorder);
        fsm.process(messages.run("X"), (ResponseHandler)recorder);
        fsm.process(messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse().hasFailureResponse((Status)Status.Statement.SyntaxError).hasIgnoredResponse();
        ConnectionAssertions.assertThat((Connection)fsm.connection()).hasTransaction();
        recorder.reset();
        fsm.process(messages.commit(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
    }

    @StateMachineTest
    void shouldCloseTransactionOnRollbackAfterFailure(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.begin(), (ResponseHandler)NoopResponseHandler.getInstance());
        fsm.process(messages.run("X"), (ResponseHandler)recorder);
        fsm.process(messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Statement.SyntaxError).hasIgnoredResponse();
        ConnectionAssertions.assertThat((Connection)fsm.connection()).hasTransaction();
        recorder.reset();
        fsm.process(messages.rollback(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
    }

    @StateMachineTest
    void shouldReportTerminationError(@InTransaction StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        Transaction tx = (Transaction)fsm.connection().transaction().orElseThrow(() -> new AssertionError((Object)"No transaction active in connection"));
        tx.interrupt();
        fsm.process(messages.run("RETURN 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Transaction.Terminated);
        StateMachineAssertions.assertThat((StateMachine)fsm).hasFailed();
        ConnectionAssertions.assertThat((Connection)fsm.connection()).hasTransaction();
    }

    @StateMachineTest
    void shouldReportTerminationErrorWithoutExplicitValidation(@InTransaction StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        Transaction tx = (Transaction)fsm.connection().transaction().orElseThrow(() -> new AssertionError((Object)"No transaction active in connection"));
        tx.interrupt();
        fsm.process(messages.run("RETURN 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Transaction.Terminated);
        StateMachineAssertions.assertThat((StateMachine)fsm).hasFailed();
        ConnectionAssertions.assertThat((Connection)fsm.connection()).hasTransaction();
    }

    @StateMachineTest
    void shouldTerminateOnInvalidStatement(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.run("\u2728\u2728\u2728 INVALID QUERY STRING \u2728\u2728\u2728"), (ResponseHandler)recorder);
        StateMachineAssertions.assertThat((StateMachine)fsm).hasFailed();
    }

    @StateMachineTest
    void shouldRespondWithIgnoredWhileInterrupted(@Streaming StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.interrupt();
        fsm.process(messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInterrupted();
    }

    private void shouldTerminateConnectionOnMessage(StateMachine fsm, RequestMessage message) {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(it -> it.process(message, (ResponseHandler)recorder));
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    @StateMachineTest
    void shouldTerminateConnectionOnHello(@Streaming StateMachine fsm, BoltMessages messages) {
        this.shouldTerminateConnectionOnMessage(fsm, messages.hello());
    }

    @StateMachineTest
    void shouldTerminateConnectionOnBegin(@Streaming StateMachine fsm, BoltMessages messages) {
        this.shouldTerminateConnectionOnMessage(fsm, messages.begin());
    }

    @StateMachineTest
    void shouldTerminateConnectionOnReset(@Streaming StateMachine fsm, BoltMessages messages) {
        this.shouldTerminateConnectionOnMessage(fsm, messages.reset());
    }

    @StateMachineTest
    void shouldTerminateConnectionOnGoodbye(@Streaming StateMachine fsm, BoltMessages messages) {
        this.shouldTerminateConnectionOnMessage(fsm, messages.goodbye());
    }

    @StateMachineTest
    void shouldAllowUserControlledRollbackOnExplicitTxFailure(@Authenticated StateMachine fsm, ResponseRecorder recorder, BoltMessages messages, Connection connection) throws StateMachineException {
        fsm.process(messages.begin(), (ResponseHandler)NoopResponseHandler.getInstance());
        fsm.process(messages.run("CREATE (n:Victim)-[:REL]->()"), (ResponseHandler)NoopResponseHandler.getInstance());
        fsm.process(messages.discard(), (ResponseHandler)NoopResponseHandler.getInstance());
        fsm.process(messages.run("this is not valid syntax"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Statement.SyntaxError);
        ConnectionAssertions.assertThat((Connection)connection).hasTransaction();
        StateMachineAssertions.assertThat((StateMachine)fsm).hasFailed();
    }
}

