/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.connection.resolver;

import java.net.SocketAddress;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.neo4j.bolt.test.annotation.connection.resolver.Connector;
import org.neo4j.bolt.test.connection.resolver.AbstractAddressResolver;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.configuration.connectors.ConnectorType;

public class ConnectorAddressResolver
extends AbstractAddressResolver {
    @Override
    protected SocketAddress doResolve(ExtensionContext extensionContext, ParameterContext context, Neo4jWithSocket server, TransportType transportType) throws ParameterResolutionException {
        return server.lookupConnector(this.getConnectorType(context)).toSocketAddress();
    }

    private ConnectorType getConnectorType(ParameterContext context) throws ParameterResolutionException {
        return context.findAnnotation(Connector.class).map(Connector::value).orElseThrow(() -> new ParameterResolutionException("Illegal parameter configuration: " + ConnectorAddressResolver.class.getSimpleName() + " must be referenced via @" + Connector.class.getSimpleName()));
    }
}

