/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.resolver.connection;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.neo4j.bolt.test.connection.initializer.ConnectionInitializer;
import org.neo4j.bolt.test.connection.resolver.AddressResolver;
import org.neo4j.bolt.test.connection.resolver.DefaultAddressResolver;
import org.neo4j.bolt.test.extension.lifecycle.TransportConnectionManager;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketSupportExtension;

public abstract class AbstractConnectionInitializingParameterResolver<E extends Exception>
implements ParameterResolver {
    private final TransportConnectionManager connectionManager;
    private final BoltWire wire;
    private final TransportType transportType;

    public AbstractConnectionInitializingParameterResolver(TransportConnectionManager connectionManager, BoltWire wire, TransportType transportType) {
        this.connectionManager = connectionManager;
        this.wire = wire;
        this.transportType = transportType;
    }

    protected TransportConnection acquireConnection(ExtensionContext extensionContext, ParameterContext context) throws E {
        Neo4jWithSocket server = Neo4jWithSocketSupportExtension.getInstance((ExtensionContext)extensionContext);
        AddressResolver resolver = AddressResolver.findResolver(context).orElseGet(DefaultAddressResolver::new);
        List<ConnectionInitializer> initializers = ConnectionInitializer.findInitializers(context);
        SocketAddress address = resolver.resolve(extensionContext, context, server, this.transportType);
        TransportConnection connection = this.connectionManager.acquire(address);
        try {
            connection.connect();
        }
        catch (IOException ex) {
            this.fail(address, ex);
        }
        try {
            for (ConnectionInitializer initializer : initializers) {
                initializer.initialize(extensionContext, context, this.wire, connection);
            }
        }
        catch (ParameterResolutionException ex) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        return connection;
    }

    protected abstract void fail(SocketAddress var1, Throwable var2) throws E;
}

