/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tls;

import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.transport.preset.SecureTransportOnly;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.test.provider.ConnectionProvider;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class PlaintextIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED);
    }

    @TransportTest
    @SecureTransportOnly
    void shouldTerminateConnectionDuringHandshake(TransportType transport, BoltWire wire, ConnectionProvider connectionProvider) throws Exception {
        String message = "Remote host terminated the handshake";
        if (transport == TransportType.WEBSOCKET_TLS) {
            message = "Failed to connect to the server within 5 minutes";
        }
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> connectionProvider.create().send(wire.getProtocolVersion())).withMessage(message);
    }
}

