/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.testing.PackstreamBufAssertions;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class BasicOperationIT {
    public static final String ELEMENT_ID_PATTERN = "\\d+:[\\da-f]{8}\\-[\\da-f]{4}\\-[\\da-f]{4}\\-[\\da-f]{4}\\-[\\da-f]{12}:\\d+";

    @ProtocolTest
    void shouldRunSimpleStatement(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(2)).containsExactly((Object[])new String[]{"a", "a_squared"}))).receivesRecord(new AnyValue[]{Values.longValue((long)1L), Values.longValue((long)1L)}).receivesRecord(new AnyValue[]{Values.longValue((long)2L), Values.longValue((long)4L)}).receivesRecord(new AnyValue[]{Values.longValue((long)3L), Values.longValue((long)9L)}).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"));
    }

    @ProtocolTest
    void shouldRespondWithMetadataToDiscardAll(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared")).send(wire.discard());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(2)).containsExactly((Object[])new String[]{"a", "a_squared"}))).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"));
    }

    @ProtocolTest
    void shouldBeAbleToRunQueryAfterAckFailure(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("QINVALID")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Statement.SyntaxError, "line 1, column 1").receivesIgnored();
        connection.send(wire.reset()).send(wire.run("RETURN 1")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess();
    }

    @ProtocolTest
    void shouldRunProcedure(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CREATE (n:Test {age: 2}) RETURN n.age AS age")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"age"}))).receivesRecord(new AnyValue[]{Values.longValue((long)2L)}).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKey((Object)"t_last"));
        connection.send(wire.run("CALL db.labels() YIELD label")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"label"}))).receivesRecord(new AnyValue[]{Values.stringValue((String)"Test")}).receivesSuccess();
    }

    @ProtocolTest
    void shouldHandleDeletedNodes(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CREATE (n:Test) DELETE n RETURN n")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"n"}))).packstreamSatisfies(pack -> ((PackstreamBufAssertions)pack.receivesMessage().containsStruct(113, 1L).containsLengthPrefixMarker(Type.LIST, 1L).containsStruct(78, wire.getProtocolVersion().major() >= 5 ? 4L : 3L).containsInt(0L).containsList(labels -> Assertions.assertThat((List)labels).isEmpty()).containsMap(props -> Assertions.assertThat((Map)props).isEmpty()).satisfies(new ThrowingConsumer[]{buf -> {
            if (wire.getProtocolVersion().major() < 5) {
                return;
            }
            PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsString(elementId -> Assertions.assertThat((String)elementId).matches((CharSequence)ELEMENT_ID_PATTERN));
        }})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKey((Object)"t_last"));
    }

    @ProtocolTest
    void shouldHandleDeletedRelationships(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CREATE (a)-[r:T {prop: 42}]->(b) DELETE r RETURN r")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_first")).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"r"}))).packstreamSatisfies(pack -> ((PackstreamBufAssertions)pack.receivesMessage().containsStruct(113, 1L).containsLengthPrefixMarker(Type.LIST, 1L).containsStruct(82, wire.getProtocolVersion().major() >= 5 ? 8L : 5L).containsAInt().containsInt(-1L).containsInt(-1L).containsString("").containsMap(props -> Assertions.assertThat((Map)props).isEmpty()).satisfies(new ThrowingConsumer[]{buf -> {
            if (wire.getProtocolVersion().major() < 5) {
                return;
            }
            PackstreamBufAssertions.assertThat((PackstreamBuf)buf).containsString(elementId -> Assertions.assertThat((String)elementId).matches((CharSequence)ELEMENT_ID_PATTERN)).containsString("").containsString("");
        }})).asBuffer().hasNoRemainingReadableBytes()).receivesSuccess();
    }

    @ProtocolTest
    void shouldNotLeakStatsToNextStatement(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CREATE (n)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("RETURN 1")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)1L)}).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKey((Object)"t_last")).containsEntry((Object)"type", (Object)"r"));
    }

    @ProtocolTest
    void shouldSendNotifications(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithNotification("Neo.ClientNotification.Statement.UnknownLabelWarning", "The provided label is not in the database.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", SeverityLevel.WARNING, 17, 1, 18);
    }

    @ProtocolTest
    void shouldFailNicelyWhenDroppingUnknownIndex(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("DROP INDEX my_index")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Schema.IndexDropFailed, "Unable to drop index called `my_index`. There is no such index.").receivesIgnored();
    }

    @ProtocolTest
    void shouldFailNicelyWhenSubmittingInvalidStatement(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("MATCH (:Movie{title:'"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.General.UnknownError, "Lexical error");
    }
}

