/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tls;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.connection.transport.IncludeTransport;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.client.tls.SecureSocketConnection;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.pki.PkiUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;
import org.neo4j.test.utils.TestDirectory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class TransportSecurityIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    private Path keyFile;
    private Path certFile;
    private X509Certificate certificate;

    @SettingsFunction
    void customizeSettings(Map<Setting<?>, Object> settings) {
        SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT);
        settings.put(policy.enabled, true);
        settings.put(policy.public_certificate, this.certFile.toAbsolutePath());
        settings.put(policy.private_key, this.keyFile.toAbsolutePath());
    }

    @BeforeAll
    void prepare() throws IOException, GeneralSecurityException, OperatorCreationException {
        this.keyFile = this.testDirectory.file("key.pem");
        this.certFile = this.testDirectory.file("key.crt");
        this.fileSystem.delete(this.keyFile);
        this.fileSystem.delete(this.certFile);
        SelfSignedCertificateFactory certificateFactory = new SelfSignedCertificateFactory();
        certificateFactory.createSelfSignedCertificate(this.fileSystem, this.certFile, this.keyFile, "my.domain");
        X509Certificate[] certificates = PkiUtils.loadCertificates((FileSystemAbstraction)this.fileSystem, (Path)this.certFile);
        Assertions.assertThat((int)certificates.length).isEqualTo(1);
        this.certificate = certificates[0];
    }

    @TransportTest
    @IncludeTransport(value={TransportType.TCP_TLS})
    void shouldUseConfiguredCertificate(@VersionSelected SecureSocketConnection connection) {
        Set certificatesSeen = connection.getServerCertificatesSeen();
        Assertions.assertThat((Collection)certificatesSeen).containsExactly((Object[])new X509Certificate[]{this.certificate});
    }
}

