/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class ResetMessageIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_timeout, Duration.ofSeconds(5L));
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes, ByteUnit.kibiBytes((long)1L));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void shouldFailAResetWhenInUnauthenticatedState(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void shouldFailAResetWhenInAuthenticationState(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void shouldResetToReadyStateWhenAuthenticated(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void shouldResetToReadyStateWhenAuthenticatedLegacy(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
    void shouldFailAResetWhenInUnauthenticatedStateLegacy(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }
}

