/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.TelemetryMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class TelemetryIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.server_bolt_telemetry_enabled, true);
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldFailToProcessTelemetryWhenOldBoltVersion(@Authenticated TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.telemetry(TelemetryMessageBuilder::withExecute));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldProcessTelemetry(@Authenticated TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.telemetry(TelemetryMessageBuilder::withExecute)).send(wire.telemetry(TelemetryMessageBuilder::withUnmanagedTransactions)).send(wire.telemetry(TelemetryMessageBuilder::withManagedTransactionFunctions)).send(wire.telemetry(TelemetryMessageBuilder::withImplicitTransactions));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(4);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldNotProcessTelemetryWhenFailed(@Authenticated TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.run("\u2728\u2728\u2728 FIRE \u2728\u2728\u2728"));
        connection.send(wire.telemetry(TelemetryMessageBuilder::withExecute)).send(wire.telemetry(TelemetryMessageBuilder::withUnmanagedTransactions)).send(wire.telemetry(TelemetryMessageBuilder::withManagedTransactionFunctions)).send(wire.telemetry(TelemetryMessageBuilder::withImplicitTransactions)).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure().receivesIgnored(5);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldFailWhenTelemetryIsReceivedPriorToNegotiation(@VersionSelected TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.telemetry(TelemetryMessageBuilder::withExecute));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Message of type TelemetryMessage cannot be handled by a session in the NEGOTIATION state.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldFailWhenTelemetryIsReceivedPriorToAuthentication(@Negotiated TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.telemetry(TelemetryMessageBuilder::withExecute));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Message of type TelemetryMessage cannot be handled by a session in the AUTHENTICATION state.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldFailWhenTelemetryIsInTxReady(@Authenticated TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.telemetry(TelemetryMessageBuilder::withExecute));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Message of type TelemetryMessage cannot be handled by a session in the IN_TRANSACTION state.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldFailWhenTelemetryIsReceivedAfterLogoff(@Authenticated TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.telemetry(TelemetryMessageBuilder::withExecute)).send(wire.logoff()).send(wire.telemetry(TelemetryMessageBuilder::withExecute));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2).receivesFailure((Status)Status.Request.Invalid, "Message of type TelemetryMessage cannot be handled by a session in the AUTHENTICATION state.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldCloseConnectionWhenANonSupportedApiTypeIsSent(@Authenticated TransportConnection connection, BoltWire wire) throws IOException {
        connection.send(wire.telemetry(TelemetryMessageBuilder::withANonValidAPIType));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }
}

