/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.struct;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;

public abstract class AbstractStructArgumentIT {
    protected void testFailureWithUnpackableValue(TransportConnection connection, Consumer<PackstreamBuf> packer, String expectedMessage) throws IOException {
        connection.send(this.createRunWith(packer));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, expectedMessage);
    }

    protected ByteBuf createRunWith(Consumer<PackstreamBuf> packer) {
        PackstreamBuf buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN $x").writeMapHeader(1L).writeString("x");
        packer.accept(buf);
        return buf.writeMapHeader(0L).getTarget();
    }
}

