/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.annotation.fsm.initializer.Authenticated;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.virtual.MapValue;

@CommunityStateMachineTestExtension
class ReadyStateIT {
    ReadyStateIT() {
    }

    @StateMachineTest
    void shouldMoveToInterruptedOnInterrupt(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.connection().interrupt();
        fsm.process(messages.run("RETURN 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInterrupted();
    }

    private void shouldCloseConnectionOnMessage(StateMachine fsm, RequestMessage message) {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(it -> it.process(message, (ResponseHandler)recorder));
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    @StateMachineTest
    void shouldCloseConnectionOnPull(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.pull());
    }

    @StateMachineTest
    void shouldCloseConnectionOnDiscard(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.discard());
    }

    @StateMachineTest
    void shouldCloseConnectionOnCommit(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.commit());
    }

    @StateMachineTest
    void shouldCloseConnectionOnRollback(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.rollback());
    }

    @StateMachineTest
    void shouldCloseConnectionOnGoodbye(@Authenticated StateMachine fsm, BoltMessages messages) {
        this.shouldCloseConnectionOnMessage(fsm, messages.goodbye());
    }

    @StateMachineTest
    void shouldMoveToAutoCommitOnRun_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.run("CREATE (n {k:'k'}) RETURN n.k"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("fields").containsKey("t_first"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTO_COMMIT);
    }

    @StateMachineTest
    void shouldMoveToInTransactionOnBegin_succ(@Authenticated StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.begin(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.IN_TRANSACTION);
    }

    @StateMachineTest(since=@Version(major=5, minor=1))
    void shouldMoveBackToAuthenticationStateAfterALogoffMessage(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws StateMachineException {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        fsm.process(messages.logon(), (ResponseHandler)recorder);
        fsm.process(messages.logoff(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(States.AUTHENTICATION);
    }
}

