/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.lifecycle;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.test.extension.db.ServerInstanceContext;
import org.neo4j.bolt.transport.Neo4jWithSocket;

public class ServerInstanceManager
implements BeforeEachCallback,
AfterEachCallback {
    private final ServerInstanceContext context;

    public ServerInstanceManager(ServerInstanceContext context) {
        this.context = context;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Neo4jWithSocket server = this.context.configure(context);
        server.init((TestInfo)new BoltTestInfo(context));
    }

    public void afterEach(ExtensionContext context) {
        this.context.stop(context);
    }

    private static class BoltTestInfo
    implements TestInfo {
        private final String displayName;
        private final Set<String> tags;
        private final Optional<Class<?>> testClass;
        private final Optional<Method> testMethod;

        private BoltTestInfo(ExtensionContext context) {
            this.displayName = context.getDisplayName();
            this.tags = context.getTags();
            this.testClass = context.getTestClass();
            this.testMethod = context.getTestMethod();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public Optional<Class<?>> getTestClass() {
            return this.testClass;
        }

        public Optional<Method> getTestMethod() {
            return this.testMethod;
        }
    }
}

