/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class TransactionTerminationIT {
    @Inject
    private Neo4jWithSocket server;

    private void awaitTransactionStart() throws InterruptedException {
        long txCount = 1L;
        while (txCount <= 1L) {
            try (Transaction tx = this.server.graphDatabaseService().beginTx();){
                Result result = tx.execute("SHOW TRANSACTIONS");
                txCount = result.stream().toList().size();
            }
            Thread.sleep(100L);
        }
    }

    @Timeout(value=15L)
    @ProtocolTest
    void killTxViaReset(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 2000000) AS i CREATE (n)"));
        this.awaitTransactionStart();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesFailure(new Status[]{Status.Transaction.Terminated, Status.Transaction.LockClientStopped}).receivesSuccess();
    }

    @Timeout(value=15L)
    @ProtocolTest
    void killTxThenTryToUseItTest(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 200) AS i RETURN i")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesRecords();
        this.awaitTransactionStart();
        try (Transaction tx = this.server.graphDatabaseService().beginTx();){
            Result result = tx.execute("SHOW TRANSACTIONS");
            Stream<Map> unwindTransaction = result.stream().toList().stream().filter(x -> !x.get("connectionId").equals("") && !x.get("clientAddress").equals(""));
            String transactionId = (String)unwindTransaction.toList().get(0).get("transactionId");
            Result terminationResult = tx.execute(String.format("TERMINATE TRANSACTION \"%s\"", transactionId));
            Map termination = (Map)terminationResult.stream().toList().get(0);
            Assertions.assertEquals(termination.get("message"), (Object)"Transaction terminated.");
        }
        connection.send(wire.run("UNWIND range(1, 200) AS i RETURN i"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Transaction.Terminated, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Explicitly terminated by the user. ");
    }

    @Timeout(value=20L)
    @ProtocolTest
    void killedTxShouldNotDestroyConnection(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 200) AS i RETURN i")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesRecords();
        this.awaitTransactionStart();
        try (Transaction tx = this.server.graphDatabaseService().beginTx();){
            Result result = tx.execute("SHOW TRANSACTIONS");
            Stream<Map> unwindTransaction = result.stream().toList().stream().filter(x -> !x.get("connectionId").equals("") && !x.get("clientAddress").equals(""));
            String transactionId = (String)unwindTransaction.toList().get(0).get("transactionId");
            Result terminationResult = tx.execute(String.format("TERMINATE TRANSACTION \"%s\"", transactionId));
            Map termination = (Map)terminationResult.stream().toList().get(0);
            Assertions.assertEquals(termination.get("message"), (Object)"Transaction terminated.");
        }
        Thread.sleep(11000L);
        connection.send(wire.run("UNWIND range(1, 200) AS i RETURN i"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Transaction.Terminated, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Explicitly terminated by the user. ");
        connection.send(wire.reset()).send(wire.begin()).send(wire.run("RETURN 1 as n")).send(wire.pull(1L)).send(wire.commit());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3).receivesRecord().receivesSuccess(2);
    }
}

