/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.connection.initializer;

import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.connection.initializer.AbstractNegotiatingConnectionInitializer;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;

public final class NegotiateConnectionInitializer
extends AbstractNegotiatingConnectionInitializer {
    @Override
    public void initialize(ExtensionContext extensionContext, ParameterContext context, BoltWire wire, TransportConnection connection) throws ParameterResolutionException {
        if (!wire.supportsLogonMessage()) {
            if (!context.isAnnotated(Authenticated.class)) {
                throw new UnsupportedOperationException("Cannot enter AUTHENTICATION stage via negotiation message in protocol version " + wire.getProtocolVersion());
            }
            return;
        }
        try {
            connection.send(wire.hello());
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> this.assertNegotiatedFeatures(wire, (Map<String, Object>)meta));
        }
        catch (IOException | AssertionError ex) {
            throw new ParameterResolutionException("Failed to authenticate connection", (Throwable)ex);
        }
    }
}

