/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.connection.transport.DefaultTransportSelector;
import org.neo4j.bolt.test.connection.transport.TransportSelector;
import org.neo4j.bolt.test.extension.BoltTestConfig;
import org.neo4j.bolt.test.extension.db.ServerInstanceContext;
import org.neo4j.bolt.test.wire.initializer.BoltWireInitializer;
import org.neo4j.bolt.test.wire.selector.BoltWireSelector;
import org.neo4j.bolt.test.wire.selector.DefaultBoltWireSelector;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public final class BoltTestSupportExtension
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Optional<Class> supportAnnotation = context.getTestMethod().flatMap(method -> AnnotationSupport.findAnnotation((AnnotatedElement)method, BoltTestExtension.class)).or(() -> context.getTestClass().flatMap(type -> AnnotationSupport.findAnnotation((AnnotatedElement)type, BoltTestExtension.class)));
        Class databaseFactoryType = supportAnnotation.map(BoltTestExtension::databaseManagementServiceBuilder).filter(type -> BoltTestExtension.PlaceholderTestDatabaseManagementServiceBuilder.class != type).orElseGet(() -> this.getDefaultDatabaseFactoryType());
        ServerInstanceContext instanceContext = ServerInstanceContext.forExtensionContext(context, databaseFactoryType, Collections.emptyList(), List.of((ctx, settings) -> {
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
        }));
        return this.getTransportTypes(context).flatMap(transportType -> this.getWires(context).map(wire -> this.configure(databaseFactoryType, instanceContext, (TransportType)transportType, (BoltWire)wire)));
    }

    protected BoltTestConfig configure(Class<? extends TestDatabaseManagementServiceBuilder> databaseFactoryType, ServerInstanceContext instanceContext, TransportType transportType, BoltWire wire) {
        return new BoltTestConfig(databaseFactoryType, instanceContext, transportType, wire);
    }

    protected Class<? extends TestDatabaseManagementServiceBuilder> getDefaultDatabaseFactoryType() {
        return TestDatabaseManagementServiceBuilder.class;
    }

    protected Stream<BoltWire> getWires(ExtensionContext context) {
        BoltWireSelector selector = BoltWireSelector.findSelector(context).orElseGet(DefaultBoltWireSelector::new);
        List<BoltWireInitializer> initializers = BoltWireInitializer.findInitializer(context);
        return selector.select(context).peek(wire -> initializers.forEach(initializer -> initializer.initialize(context, (BoltWire)wire)));
    }

    protected Stream<TransportType> getTransportTypes(ExtensionContext context) {
        TransportSelector selector = TransportSelector.findSelector(context).orElseGet(DefaultTransportSelector::new);
        return selector.select(context);
    }
}

