/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.util.ServerUtil;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.fabric.bolt.QueryRouterBookmark;
import org.neo4j.fabric.bookmark.BookmarkFormat;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class BookmarkIT {
    @Inject
    private Neo4jWithSocket server;

    @ProtocolTest
    void shouldReturnUpdatedBookmarkAfterAutoCommitTransaction(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        long lastClosedTransactionId = ServerUtil.getLastClosedTransactionId(this.server);
        String expectedBookmark = BookmarkFormat.serialize((QueryRouterBookmark)new QueryRouterBookmark(List.of(new QueryRouterBookmark.InternalGraphState(ServerUtil.getDatabaseId(this.server).databaseId().uuid(), lastClosedTransactionId + 1L)), List.of()));
        connection.send(wire.run("CREATE ()"));
        connection.send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(map -> Assertions.assertThat((Map)map).containsEntry((Object)"bookmark", (Object)expectedBookmark));
    }

    @ProtocolTest
    void shouldReturnUpdatedBookmarkAfterExplicitTransaction(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        long lastClosedTransactionId = ServerUtil.getLastClosedTransactionId(this.server);
        String expectedBookmark = BookmarkFormat.serialize((QueryRouterBookmark)new QueryRouterBookmark(List.of(new QueryRouterBookmark.InternalGraphState(ServerUtil.getDatabaseId(this.server).databaseId().uuid(), lastClosedTransactionId + 1L)), List.of()));
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.run("CREATE ()")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(meta -> Assertions.assertThat((Map)meta).doesNotContainKey((Object)"bookmark"));
        connection.send(wire.commit());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"bookmark", (Object)expectedBookmark));
    }
}

