/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValueBuilder;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class ProtocolViolationIT {
    private static void sendRun(TransportConnection connection, Consumer<PackstreamBuf> packer) throws IOException {
        PackstreamBuf buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN $x").writeMapHeader(1L).writeString("x");
        packer.accept(buf);
        connection.send(buf.writeMapHeader(0L).getTarget());
    }

    @ProtocolTest
    void shouldFailWhenNullKeyIsSent(@Authenticated TransportConnection connection) throws IOException {
        ProtocolViolationIT.sendRun(connection, buf -> buf.writeMapHeader(1L).writeNull().writeString("foo"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected type: Expected STRING but got NONE");
    }

    @ProtocolTest
    void shouldFailWhenDuplicateKeyIsSent(@Authenticated TransportConnection connection) throws IOException {
        ProtocolViolationIT.sendRun(connection, buf -> buf.writeMapHeader(2L).writeString("foo").writeString("bar").writeString("foo").writeString("changed_my_mind"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"params\": Duplicate map key: \"foo\"");
    }

    @ProtocolTest
    void shouldFailWhenNodeIsSentWithRun(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        MapValueBuilder properties = new MapValueBuilder();
        properties.add("the_answer", (AnyValue)Values.longValue((long)42L));
        properties.add("one_does_not_simply", (AnyValue)Values.stringValue((String)"break_decoding"));
        ProtocolViolationIT.sendRun(connection, buf -> wire.nodeValue(buf, "42", 42, List.of("Broken", "Dreams")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x4E");
    }

    @ProtocolTest
    void shouldFailWhenRelationshipIsSentWithRun(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        MapValueBuilder properties = new MapValueBuilder();
        properties.add("the_answer", (AnyValue)Values.longValue((long)42L));
        properties.add("one_does_not_simply", (AnyValue)Values.stringValue((String)"break_decoding"));
        ProtocolViolationIT.sendRun(connection, buf -> wire.relationshipValue(buf, "42", 42, "21", 21, "84", 84, "RUINS_EXPECTATIONS"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x52");
    }

    @ProtocolTest
    void shouldFailWhenPathIsSentWithRun(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        ProtocolViolationIT.sendRun(connection, buf -> {
            buf.writeStructHeader(new StructHeader(3L, StructType.PATH.getTag()));
            buf.writeListHeader(2);
            wire.nodeValue(buf, "42", 42, List.of("Computer"));
            wire.nodeValue(buf, "84", 84, List.of("Vendor"));
            buf.writeListHeader(1);
            wire.unboundRelationshipValue(buf, "13", 13, "MAKES");
            buf.writeListHeader(2);
            buf.writeInt(1L);
            buf.writeInt(1L);
        });
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"params\": Unexpected struct tag: 0x50");
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldTerminateConnectionWhenUnknownMessageIsSent(@Authenticated TransportConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 66)).writeListHeader(1).writeInt(42L));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
    }
}

