/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.transport.ExcludeTransport;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.test.util.ServerUtil;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.SpiedAssertableLogProvider;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
@ExcludeTransport(value={TransportType.UNIX})
public class ShutdownSequenceIT {
    private static final Duration THREAD_POOL_SHUTDOWN_WAIT_TIME = Duration.ofMinutes(10L);
    private final AssertableLogProvider internalLogProvider = new SpiedAssertableLogProvider(BoltServer.class);
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    @Inject
    private Neo4jWithSocket server;
    private CountDownLatch txStarted;
    private CountDownLatch boltWorkerThreadPoolShuttingDown;

    @FactoryFunction
    void customizeServer(TestDatabaseManagementServiceBuilder factory) {
        factory.setInternalLogProvider((InternalLogProvider)this.internalLogProvider);
        factory.setUserLogProvider((LogProvider)this.userLogProvider);
    }

    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.thread_pool_min_size, 0);
        settings.put(BoltConnector.thread_pool_max_size, 2);
        settings.put(BoltConnectorInternalSettings.thread_pool_shutdown_wait_time, THREAD_POOL_SHUTDOWN_WAIT_TIME);
    }

    @BeforeEach
    void prepare() throws KernelException {
        this.txStarted = new CountDownLatch(1);
        this.boltWorkerThreadPoolShuttingDown = new CountDownLatch(1);
        ServerUtil.registerComponent(this.server, Pair.class, context -> Pair.of((Object)this.txStarted, (Object)this.boltWorkerThreadPoolShuttingDown));
        ServerUtil.installProcedure(this.server, TestProcedures.class);
    }

    @AfterEach
    void cleanup() {
        this.userLogProvider.clear();
        this.internalLogProvider.clear();
    }

    @TransportTest
    void shouldReturnFailureForTransactionAwareConnections(BoltWire wire, @Authenticated TransportConnection connection) throws IOException, InterruptedException {
        connection.send(wire.run("CALL test.stream.nodes()")).send(wire.pull());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.txStarted.await(1L, TimeUnit.MINUTES));
        InternalLog boltLog = this.internalLogProvider.getLog(BoltServer.class);
        ((InternalLog)Mockito.doAnswer(invocation -> {
            invocation.callRealMethod();
            this.boltWorkerThreadPoolShuttingDown.countDown();
            return null;
        }).when((Object)boltLog)).info("Shutting down Bolt server");
        this.server.getManagementService().shutdown();
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesFailure(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"code", (Object)Status.General.DatabaseUnavailable.code().serialize())).containsEntry((Object)"message", (Object)"The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. The database is not currently available to serve your request, refer to the database logs for more details. Retrying your request at a later time may succeed. ")).isEventuallyTerminated();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(BoltServer.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Bolt server has been shut down"});
    }

    @TransportTest
    void shutdownShouldCloseIdleConnections(@Authenticated TransportConnection connection) throws IOException {
        this.server.getManagementService().shutdown();
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(BoltServer.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Bolt server has been shut down"});
    }

    @TransportTest
    void shutdownShouldWaitForNonTransactionAwareConnections(BoltWire wire, @Authenticated TransportConnection connection) throws IOException, InterruptedException {
        connection.send(wire.run("CALL test.stream.strings()")).send(wire.pull());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.txStarted.await(1L, TimeUnit.MINUTES));
        InternalLog boltLog = this.internalLogProvider.getLog(BoltServer.class);
        ((InternalLog)Mockito.doAnswer(invocation -> {
            invocation.callRealMethod();
            this.boltWorkerThreadPoolShuttingDown.countDown();
            return null;
        }).when((Object)boltLog)).info("Shutting down Bolt server");
        this.server.getManagementService().shutdown();
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesRecord(record -> ((IterableAssert)Assertions.assertThat((Iterable)record).hasSize(1)).contains((Object[])new AnyValue[]{Values.stringValue((String)"0")})).receivesFailure(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsEntry((Object)"code", (Object)Status.General.DatabaseUnavailable.code().serialize())).containsEntry((Object)"message", (Object)"The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. The database is not currently available to serve your request, refer to the database logs for more details. Retrying your request at a later time may succeed. ")).isEventuallyTerminated();
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(BoltServer.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Bolt server has been shut down"});
    }

    public static class TestProcedures {
        @Context
        public GraphDatabaseService db;
        @Context
        public Pair<CountDownLatch, CountDownLatch> pair;
        @Context
        public Transaction tx;

        @Procedure(name="test.stream.strings", mode=Mode.READ)
        public Stream<Output> streamStrings() {
            ((CountDownLatch)this.pair.first()).countDown();
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)((CountDownLatch)this.pair.other()).await(1L, TimeUnit.MINUTES));
            }
            catch (InterruptedException e) {
                org.junit.jupiter.api.Assertions.fail((String)"Interrupted while waiting for bolt worker threads shut down.");
            }
            return Stream.of(new Output(String.valueOf(0)));
        }

        @Procedure(name="test.stream.nodes", mode=Mode.READ)
        public Stream<Output> streamNodes() {
            ((CountDownLatch)this.pair.first()).countDown();
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)((CountDownLatch)this.pair.other()).await(1L, TimeUnit.MINUTES));
            }
            catch (InterruptedException e) {
                org.junit.jupiter.api.Assertions.fail((String)"Interrupted while waiting for bolt worker threads shut down.");
            }
            this.tx.getNodeById(0L);
            return Stream.of(new Output(String.valueOf(0)));
        }

        public static class Output {
            public String out;

            Output(String value) {
                this.out = value;
            }
        }
    }
}

