/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
@ExcludeWire(value={@Version(major=4), @Version(major=5, minor=2, range=2)})
public class BoltAgentIT {
    @ProtocolTest
    void shouldSucceedWhenAddingExtraValues(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.hello(x -> x.withBoltAgent(Map.of("product", "test-agent", "extra", "included"))));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldFailWhenBoltAgentIsOmitted(@VersionSelected TransportConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none", "user_agent", "ignore")).getTarget());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.");
    }

    @ProtocolTest
    void shouldFailWhenInvalidBoltAgentIsGiven(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent((Object)"42L")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.");
    }

    @ProtocolTest
    void shouldFailWhenBoltAgentInvalidValues(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent(Map.of("product", 1))));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.");
    }

    @ProtocolTest
    void shouldFailWhenBoltAgentMissingProduct(BoltWire wire, @VersionSelected TransportConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent(Map.of("invalid", "value"))));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Expected map to contain key: 'product'.");
    }
}

