/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class NegotiationIT {
    @Inject
    private OtherThread otherThread;

    @ProtocolTest
    void shouldNegotiateProtocolVersion(BoltWire wire, TransportConnection connection) throws Exception {
        connection.send(wire.getProtocolVersion());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).negotiates(wire.getProtocolVersion());
    }

    @TransportTest
    void shouldReturnNilOnNoApplicableVersion(TransportConnection connection) throws Exception {
        connection.connect().send(new ProtocolVersion(254, 0, 0));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).failsToNegotiateVersion();
    }

    @TransportTest
    void shouldNegotiateOnRange(TransportConnection connection) throws Exception {
        ProtocolVersion range = new ProtocolVersion((int)TransportConnection.DEFAULT_PROTOCOL_VERSION.major(), TransportConnection.DEFAULT_PROTOCOL_VERSION.minor() + 2, 2);
        connection.connect().send(range);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).negotiates(TransportConnection.DEFAULT_PROTOCOL_VERSION);
    }

    @TransportTest
    void shouldNegotiateWhenPreferredIsUnavailable(BoltWire wire, TransportConnection connection) throws Exception {
        connection.send(new ProtocolVersion(255, 0, 0), wire.getProtocolVersion());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).negotiates(wire.getProtocolVersion());
    }

    @TransportTest
    void shouldTimeoutWhenHandshakeIsTransmittedTooSlowly(TransportConnection connection) throws Exception {
        ByteBuf handshakeBytes = Unpooled.buffer().writeInt(1616949271).writeInt(TransportConnection.DEFAULT_PROTOCOL_VERSION.encode()).writeInt(ProtocolVersion.INVALID.encode()).writeInt(ProtocolVersion.INVALID.encode()).writeInt(ProtocolVersion.INVALID.encode());
        this.otherThread.execute(() -> {
            while (handshakeBytes.isReadable()) {
                connection.sendRaw(handshakeBytes.readSlice(1));
                Thread.sleep(500L);
            }
            return null;
        });
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
    }

    @TransportTest
    void shouldTimeoutWhenTruncatedHandshakeIsTransmitted(TransportConnection connection) throws IOException {
        ByteBuf buf = Unpooled.buffer().writeInt(1616949271);
        connection.connect().sendRaw(buf);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
    }
}

