/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.BeginMessageBuilder;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;
import org.neo4j.bolt.testing.messages.factory.NotificationsMessageBuilder;
import org.neo4j.bolt.testing.messages.factory.RunMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class NotificationsConfigIT {
    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnSuccess(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.NONE)));
        connection.send(wire.logon());
        connection.send(wire.run("RETURN 1")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesRecord(new AnyValue[]{Values.intValue((int)1)});
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_00000);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnNoData(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.NONE)));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (a) RETURN a")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_02000);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnSuccessOmittedResult(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.NONE)));
        connection.send(wire.logon());
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_00001);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnWarning(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.WARNING)));
        connection.send(wire.logon());
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_01N50, "The label `THIS_IS_NOT_A_LABEL` does not exist. Verify that the spelling is correct.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", "The provided label is not in the database.", "Neo.ClientNotification.Statement.UnknownLabelWarning", BoltConnectionAssertions.assertDiagnosticRecord((SeverityLevel)SeverityLevel.WARNING, (NotificationCategory)NotificationCategory.UNRECOGNIZED, Map.of("label", "THIS_IS_NOT_A_LABEL"), (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)18L, (long)1L, (long)17L)));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnMultipleCartesianProductWarning(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> {
            x.withDisabledCategories(Set.of(NotificationConfiguration.Category.UNRECOGNIZED));
            return x;
        }));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (n:thisLabelDoesNotExist), (m:thisLabelDoesNotExist) return m, n")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(2));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnSingleUnboundedVariableLengthWarning(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> {
            x.withDisabledCategories(Set.of(NotificationConfiguration.Category.UNRECOGNIZED));
            return x;
        }));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH shortestPath((n:A)-[*]->(m:B)) return m, n")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(2));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnSingleRepeatedRelationshipWarning(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello());
        connection.send(wire.logon());
        connection.send(wire.run("MATCH ()-[r]-()-[r]-() RETURN r AS r")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(2));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldSendFailureWithUnknownSeverity(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withUnknownSeverity("WANING")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldSendFailureWithUnknownClassification(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withUnknownDisabledCategories(List.of("Pete"))));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldNotReturnOnlyGeneralStatusWhenAllDisabled(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(1));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldReturnMultipleStatuses(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello());
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (a:Person) CALL () { MATCH (a:Label) RETURN a AS aLabel } RETURN a")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(x -> {
            Assertions.assertThat((Map)x).containsKey((Object)"statuses");
            Assertions.assertThat((List)((ArrayList)x.get("statuses"))).hasSize(4);
        });
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldEnableNotificationsForQuery(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(1));
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)", x -> (RunMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.INFORMATION))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_01N50, "The label `THIS_IS_NOT_A_LABEL` does not exist. Verify that the spelling is correct.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", "The provided label is not in the database.", "Neo.ClientNotification.Statement.UnknownLabelWarning", BoltConnectionAssertions.assertDiagnosticRecord((SeverityLevel)SeverityLevel.WARNING, (NotificationCategory)NotificationCategory.UNRECOGNIZED, Map.of("label", "THIS_IS_NOT_A_LABEL"), (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)18L, (long)1L, (long)17L)));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldSendFailureOnRunWithUnknownSeverity(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("RETURN 1 as n", x -> (RunMessageBuilder)x.withUnknownSeverity("boom")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldSendFailureOnRunWithUnknownClassification(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("RETURN 1 as n", x -> (RunMessageBuilder)x.withUnknownDisabledCategories(List.of("boom"))));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldEnableNotificationsForQueryUsingClassifications(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(1));
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)", x -> (RunMessageBuilder)x.withDisabledCategories(Collections.emptyList()))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_01N50, "The label `THIS_IS_NOT_A_LABEL` does not exist. Verify that the spelling is correct.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", "The provided label is not in the database.", "Neo.ClientNotification.Statement.UnknownLabelWarning", BoltConnectionAssertions.assertDiagnosticRecord((SeverityLevel)SeverityLevel.WARNING, (NotificationCategory)NotificationCategory.UNRECOGNIZED, Map.of("label", "THIS_IS_NOT_A_LABEL"), (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)18L, (long)1L, (long)17L)));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldEnableNotificationsInBegin(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(1));
        connection.send(wire.begin(x -> (BeginMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.WARNING)));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_01N50, "The label `THIS_IS_NOT_A_LABEL` does not exist. Verify that the spelling is correct.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", "The provided label is not in the database.", "Neo.ClientNotification.Statement.UnknownLabelWarning", BoltConnectionAssertions.assertDiagnosticRecord((SeverityLevel)SeverityLevel.WARNING, (NotificationCategory)NotificationCategory.UNRECOGNIZED, Map.of("label", "THIS_IS_NOT_A_LABEL"), (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)18L, (long)1L, (long)17L)));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldEnableNotificationsInBeginWithClassifications(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(NotificationsMessageBuilder::withDisabledNotifications));
        connection.send(wire.logon());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(1));
        connection.send(wire.begin(x -> (BeginMessageBuilder)x.withDisabledCategories(Collections.emptyList())));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.run("EXPLAIN MATCH (a:THIS_IS_NOT_A_LABEL) RETURN count(*)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccessWithStatus(GqlStatusInfoCodes.STATUS_01N50, "The label `THIS_IS_NOT_A_LABEL` does not exist. Verify that the spelling is correct.", "One of the labels in your query is not available in the database, make sure you didn't misspell it or that the label is available when you run this statement in your application (the missing label name is: THIS_IS_NOT_A_LABEL)", "The provided label is not in the database.", "Neo.ClientNotification.Statement.UnknownLabelWarning", BoltConnectionAssertions.assertDiagnosticRecord((SeverityLevel)SeverityLevel.WARNING, (NotificationCategory)NotificationCategory.UNRECOGNIZED, Map.of("label", "THIS_IS_NOT_A_LABEL"), (Map)BoltConnectionAssertions.diagnosticRecordPosition((long)18L, (long)1L, (long)17L)));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldNotReturnNotificationsInDisabledClassifications(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withDisabledCategories(List.of(NotificationConfiguration.Category.GENERIC, NotificationConfiguration.Category.UNRECOGNIZED))));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (a:Person) CALL () { MATCH (a:Label) RETURN a AS aLabel } RETURN a")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((int)((ArrayList)meta.get("statuses")).size()).isEqualTo(1));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=4, range=4), @Version(major=4)})
    public void shouldNotReturnStatusWhenNotHighEnoughSeverity(BoltWire wire, @VersionSelected TransportConnection connection) throws Throwable {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withSeverity(NotificationConfiguration.Severity.WARNING)));
        connection.send(wire.logon());
        connection.send(wire.run("MATCH (a:Person) CALL { MATCH (a:Label) RETURN a AS aLabel } RETURN a")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(x -> Assertions.assertThat((String)x.get("statuses").toString()).doesNotContain(new CharSequence[]{"GENERIC"}));
    }
}

