/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.provider.ConnectionProvider;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.batchimport.HighestId;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.util.concurrent.Futures;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class ConcurrentAccessIT {
    private static final int NUM_WORKERS = 4;
    private static final int NUM_REQUESTS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWorkload(ConnectionProvider connectionProvider, int nWorkers, int nTimes, ThrowingConsumer<TransportConnection, IOException> workload) throws InterruptedException, ExecutionException {
        DoubleLatch barrier = new DoubleLatch(nWorkers);
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        AtomicInteger numActiveWorkers = new AtomicInteger();
        HighestId highestNumConcurrentWorkers = new HighestId();
        for (int i = 0; i < nWorkers; ++i) {
            tasks.add(() -> {
                TransportConnection connection = connectionProvider.create();
                barrier.startAndWaitForAllToStart();
                highestNumConcurrentWorkers.offer((long)numActiveWorkers.incrementAndGet());
                for (int j = 0; j < nTimes; ++j) {
                    workload.accept((Object)connection);
                }
                barrier.finishAndWaitForAllToFinish();
                return null;
            });
        }
        ExecutorService pool = Executors.newFixedThreadPool(nWorkers);
        try {
            List futures = pool.invokeAll(tasks);
            Futures.getAllResults(futures);
            Assertions.assertThat((long)highestNumConcurrentWorkers.get()).isEqualTo((long)nWorkers);
        }
        finally {
            pool.shutdownNow();
            pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    @ProtocolTest
    void shouldRunSimpleStatement(@Authenticated ConnectionProvider connectionProvider, BoltWire wire) throws Exception {
        this.runWorkload(connectionProvider, 4, 100, (ThrowingConsumer<TransportConnection, IOException>)((ThrowingConsumer)connection -> {
            connection.send(wire.begin()).send(wire.run("CREATE (n)")).send(wire.pull()).send(wire.rollback());
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_first", "qid"})).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).isEmpty())).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_last", "db"})).receivesSuccess();
            connection.send(wire.run("MATCH (n) RETURN n")).send(wire.pull());
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_first"})).hasEntrySatisfying((Object)"fields", fields -> ((ListAssert)((ListAssert)Assertions.assertThat((Object)fields).asInstanceOf(InstanceOfAssertFactories.list(String.class))).hasSize(1)).containsExactly((Object[])new String[]{"n"}))).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"t_last", "db"}));
        }));
    }
}

