/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.bolt.protocol.common.connector.connection.AtomicSchedulingConnection;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Connected;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.test.provider.ConnectionProvider;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
public class AuthenticationIT {
    protected final AssertableLogProvider userLogProvider = new AssertableLogProvider();

    @FactoryFunction
    protected void customizeDatabase(TestDatabaseManagementServiceBuilder factory) {
        factory.setUserLogProvider((LogProvider)this.userLogProvider);
    }

    @SettingsFunction
    protected void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(GraphDatabaseSettings.auth_enabled, true);
        settings.put(BoltConnector.advertised_address, new SocketAddress("my-server.neo4j.io", 7688));
    }

    @AfterEach
    void cleanup() {
        this.userLogProvider.clear();
    }

    private static MapValue singletonMap(String key, Object value) {
        return VirtualValues.map((String[])new String[]{key}, (AnyValue[])new AnyValue[]{ValueUtils.of((Object)value)});
    }

    @ProtocolTest
    void shouldRespondWithCredentialsExpiredOnFirstUse(BoltWire wire, @VersionSelected BoltTestConnection connection) throws InterruptedException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfWrongCredentialsV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "wrong")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.").isEventuallyTerminated();
        Assert.assertEventually(() -> "Matching log call not found in\n" + this.userLogProvider.serialize(), () -> {
            try {
                LogAssertions.assertThat((AssertableLogProvider)this.userLogProvider).forClass(AtomicSchedulingConnection.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"The client is unauthorized due to authentication failure."});
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }, (Condition)Conditions.TRUE, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfWrongCredentials(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "wrong")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").isEventuallyTerminated();
        Assert.assertEventually(() -> "Matching log call not found in\n" + this.userLogProvider.serialize(), () -> {
            try {
                LogAssertions.assertThat((AssertableLogProvider)this.userLogProvider).forClass(AtomicSchedulingConnection.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"The client is unauthorized due to authentication failure."});
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }, (Condition)Conditions.TRUE, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfWrongCredentialsFollowingSuccessfulLoginV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "secretPassword")).withDatabase("system")));
        connection.send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        connection.reconnect();
        wire.negotiate(connection);
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "secretPassword")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.reconnect();
        wire.negotiate(connection);
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.").isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfWrongCredentialsFollowingSuccessfulLogin(BoltWire wire, @VersionSelected ConnectionProvider connectionProvider) {
        try (BoltTestConnection connection = connectionProvider.create();){
            connection.send(wire.hello());
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
            connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
            connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "secretPassword")).withDatabase("system")));
            connection.send(wire.pull());
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(2);
        }
        connection = connectionProvider.create();
        try {
            connection.send(wire.hello());
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
            connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "secretPassword")));
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = connectionProvider.create();
        try {
            connection.send(wire.hello());
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
            connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").isEventuallyTerminated();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfMalformedAuthTokenWrongTypeV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", List.of("neo4j"), "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Security.Unauthorized, "Unsupported authentication token, the value associated with the key `principal` must be a String but was: ArrayList").isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfMalformedAuthTokenWrongType(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", List.of("neo4j"), "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Security.Unauthorized, "Unsupported authentication token, the value associated with the key `principal` must be a String but was: ArrayList", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").isEventuallyTerminated();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfMalformedAuthTokenMissingKeyV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "this-should-have-been-credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `credentials`").isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfMalformedAuthTokenMissingKey(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "this-should-have-been-credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `credentials`", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").isEventuallyTerminated();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfMalformedAuthTokenMissingSchemeV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `scheme`").isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailIfMalformedAuthTokenMissingScheme(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `scheme`", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").isEventuallyTerminated();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    protected void shouldFailIfMalformedAuthTokenUnknownSchemeV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "unknown", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Security.Unauthorized, "Unsupported authentication token, scheme 'unknown' is not supported.").isEventuallyTerminated();
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    protected void shouldFailIfMalformedAuthTokenUnknownScheme(BoltWire wire, @VersionSelected BoltTestConnection connection) throws InterruptedException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "unknown", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Security.Unauthorized, "Unsupported authentication token, scheme 'unknown' is not supported.", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").isEventuallyTerminated();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailDifferentlyIfTooManyFailedAuthAttemptsV40(BoltWire wire, @Connected ConnectionProvider connectionProvider) {
        Assert.awaitUntilAsserted(() -> {
            try (BoltTestConnection connection = connectionProvider.create();){
                connection.reconnect();
                wire.negotiate(connection);
                connection.send(wire.hello());
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
                connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "WHAT_WAS_THE_PASSWORD_AGAIN")));
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Security.AuthenticationRateLimit, "The client has provided incorrect authentication details too many times in a row.").isEventuallyTerminated();
            }
        });
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailDifferentlyIfTooManyFailedAuthAttempts(BoltWire wire, @Connected ConnectionProvider connectionProvider) {
        Assert.awaitUntilAsserted(() -> {
            try (BoltTestConnection connection = connectionProvider.create();){
                wire.negotiate(connection);
                connection.send(wire.hello());
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
                connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "WHAT_WAS_THE_PASSWORD_AGAIN")));
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Security.AuthenticationRateLimit, "The client has provided incorrect authentication details too many times in a row.", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").isEventuallyTerminated();
            }
        });
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenReusingTheSamePasswordV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "password")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3);
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'password' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "password")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Statement.ArgumentError, "Old password and new password cannot be the same.").receivesIgnored();
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'password' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "abcdefgh")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenReusingTheSamePassword(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "password")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3);
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'password' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "password")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyWithCause((Status)Status.Statement.ArgumentError, "Old password and new password cannot be the same.", GqlStatusInfoCodes.STATUS_22N05.getGqlStatus(), "error: data exception - input failed validation. Invalid input '***' for neo4j password.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCause((String)"2N89: Expected the new password to be different from the old password.", (GqlStatus)GqlStatusInfoCodes.STATUS_22N89.getGqlStatus(), (String)"error: data exception - new password cannot be the same as the old password. Expected the new password to be different from the old password.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))).receivesIgnored();
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'password' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "abcdefgh")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3);
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenSubmittingEmptyPasswordV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Statement.ArgumentError, "A password cannot be empty.").receivesIgnored();
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "abcdefgh")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenSubmittingEmptyPassword(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Statement.ArgumentError, "A password cannot be empty.", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.").receivesIgnored();
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", x -> x.withParameters(AuthenticationIT.singletonMap("password", "abcdefgh")).withDatabase("system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(3);
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldNotBeAbleToReadWhenPasswordChangeRequiredV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.run("MATCH (n) RETURN n")).send(wire.pull());
        try {
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Security.CredentialsExpired, "The credentials you provided were valid, but must be changed before you can use this instance.");
        }
        catch (AssertionError ignore) {
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Security.CredentialsExpired, "The credentials you provided were valid, but must be changed before you can use this instance.");
        }
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldNotBeAbleToReadWhenPasswordChangeRequired(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.run("MATCH (n) RETURN n")).send(wire.pull());
        try {
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Security.CredentialsExpired, "The credentials you provided were valid, but must be changed before you can use this instance.", GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus(), "error: syntax error or access rule violation - permission/access denied. Access denied, see the security logs for details.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCause((String)"", (GqlStatus)GqlStatusInfoCodes.STATUS_42NFD.getGqlStatus(), (String)"error: syntax error or access rule violation - credentials expired. Permission denied. The credentials you provided were valid, but must be changed before you can use this instance.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR")));
        }
        catch (StackOverflowError ignore) {
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Security.CredentialsExpired, "The credentials you provided were valid, but must be changed before you can use this instance.", GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus(), "error: syntax error or access rule violation - permission/access denied. Access denied, see the security logs for details.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCause((String)"", (GqlStatus)GqlStatusInfoCodes.STATUS_42NFD.getGqlStatus(), (String)"error: syntax error or access rule violation - credentials expired. Permission denied. The credentials you provided were valid, but must be changed before you can use this instance.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR")));
        }
    }

    @ProtocolTest
    void shouldBeAbleToLogoffAfterBeingAuthenticatedThenLogBackOn(BoltWire wire, @VersionSelected BoltTestConnection connection) throws InterruptedException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.logoff());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldNotBeAbleToAuthenticateOnHelloMessageV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withBasicAuth("neo4j", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzyV40((Status)Status.Request.Invalid, "cannot be handled by a session in the AUTHENTICATION state.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldNotBeAbleToAuthenticateOnHelloMessage(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> (HelloMessageBuilder)x.withBasicAuth("neo4j", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, "cannot be handled by a session in the AUTHENTICATION state.", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.");
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=7, range=6)})
    void shouldNotReturnAdvertiseAddressOnLogonMessageSuccess(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).doesNotContainKeys((Object[])new String[]{"advertised_address"}));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=7, range=7), @Version(major=4)})
    void shouldReturnAdvertiseAddressOnLogonMessageSuccess(BoltWire wire, @VersionSelected BoltTestConnection connection) {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"advertised_address", (Object)"my-server.neo4j.io:7688"));
    }
}

