/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
@ExcludeWire(value={@Version(major=4), @Version(major=5, minor=2, range=2)})
public class BoltAgentIT {
    @ProtocolTest
    void shouldSucceedWhenAddingExtraValues(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> x.withBoltAgent(Map.of("product", "test-agent", "extra", "included"))));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenBoltAgentIsOmittedV40(@VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none", "user_agent", "ignore")).getTarget());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenBoltAgentIsOmitted(@VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none", "user_agent", "ignore")).getTarget());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value null to be of type MAP<STRING, STRING>, but was of type null.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenInvalidBoltAgentIsGivenV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent((Object)"42L")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenInvalidBoltAgentIsGiven(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent((Object)"42L")));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 42L to be of type MAP<STRING, STRING>, but was of type String.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenBoltAgentInvalidValuesV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent(Map.of("product", 1))));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenBoltAgentInvalidValues(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent(Map.of("product", 1))));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Must be a map with string keys and string values.", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value product=1 to be of type MAP<STRING, STRING>, but was of type class java.util.HashMap$Node.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenBoltAgentMissingProductV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent(Map.of("invalid", "value"))));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Expected map to contain key: 'product'.");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenBoltAgentMissingProduct(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withBadBoltAgent(Map.of("invalid", "value"))));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"bolt_agent\": Expected map to contain key: 'product'.", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.");
    }
}

