/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension;

import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.neo4j.bolt.test.extension.db.ServerInstanceContext;
import org.neo4j.bolt.test.extension.lifecycle.ServerInstanceManager;
import org.neo4j.bolt.test.extension.lifecycle.TransportConnectionManager;
import org.neo4j.bolt.test.extension.resolver.connection.ConnectionProviderParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.SocketAddressParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.TransportConnectionParameterResolver;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.extension.parameter.StaticParameterResolver;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

record BoltTestConfig(Class<? extends TestDatabaseManagementServiceBuilder> databaseFactoryType, ServerInstanceContext instanceContext, TransportType transport, BoltWire wire) implements TestTemplateInvocationContext
{
    public String getDisplayName(int invocationIndex) {
        return String.valueOf(this.wire.getProtocolVersion()) + " via " + this.transport.name();
    }

    public List<Extension> getAdditionalExtensions() {
        TransportConnectionManager connectionManager = new TransportConnectionManager(this.transport);
        return List.of(new ServerInstanceManager(this.instanceContext), connectionManager, new StaticParameterResolver(BoltWire.class, (Object)this.wire), new StaticParameterResolver(TransportType.class, (Object)this.transport), new SocketAddressParameterResolver(), new ConnectionProviderParameterResolver(connectionManager, this.wire, this.transport), new TransportConnectionParameterResolver(connectionManager, this.wire, this.transport));
    }
}

