/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class UserAgentIT {
    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenUserAgentIsOmittedV40(@VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none")).getTarget());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected value to be non-null");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenUserAgentIsOmitted(@VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMap(Map.of("scheme", "none")).getTarget());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected value to be non-null", GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), "error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details.");
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenInvalidUserAgentIsGivenV40(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withUserAgent((Object)42L)));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected string");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenInvalidUserAgentIsGiven(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello(x -> ((HelloMessageBuilder)x.withScheme("none")).withUserAgent((Object)42L)));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, "Illegal value for field \"user_agent\": Expected string", GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22G03", (GqlStatus)GqlStatusInfoCodes.STATUS_22G03.getGqlStatus(), (String)"error: data exception - invalid value type", null, (Consumer)BoltConnectionAssertions.assertErrorCause((String)"", (GqlStatus)GqlStatusInfoCodes.STATUS_22N01.getGqlStatus(), (String)"error: data exception - invalid type. Expected the value 42 to be of type STRING, but was of type Long.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"))));
    }
}

