/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.VersionSelected;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class ConnectionHintIT {
    @SettingsFunction
    protected void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.server_bolt_telemetry_enabled, true);
        settings.put(GraphDatabaseSettings.routing_enabled, true);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldIncludeTelemetryHintOnCompatibleVersions(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).extractingByKey((Object)"hints").asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).containsEntry((Object)"telemetry.enabled", (Object)true));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=4), @Version(major=5, minor=3, range=3)})
    void shouldExcludeTelemetryHintOnLegacyVersions(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).extractingByKey((Object)"hints").asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).doesNotContainKey((Object)"telemetry.enabled"));
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4), @Version(major=5, minor=7, range=7)})
    void shouldIncludeSSRHintOnCompatibleVersions(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).extractingByKey((Object)"hints").asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).containsEntry((Object)"ssr.enabled", (Object)true));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=4), @Version(major=5, minor=7, range=7)})
    void shouldExcludeSSRHintOnLegacyVersions(BoltWire wire, @VersionSelected BoltTestConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> ((MapAssert)Assertions.assertThat((Map)meta).extractingByKey((Object)"hints").asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).doesNotContainKey((Object)"ssr.enabled"));
    }
}

