/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.messages.BoltDefaultWire;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.sequence.RequestSequence;
import org.neo4j.bolt.testing.sequence.RequestSequenceCollection;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.SpiedAssertableLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@Disabled(value="Disabled since 2022-05-30. As of 2023-02-03 there are plans to reevaluating this test.")
@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
public class ResetFuzzIT {
    private static final int TEST_EXECUTION_TIME = 2000;
    private static final String SHORT_QUERY_1 = "CREATE (n:Node {name: 'foo', occupation: 'bar'})";
    private static final String SHORT_QUERY_2 = "MATCH (n:Node {name: 'foo'}) RETURN count(n)";
    private static final String SHORT_QUERY_3 = "RETURN 1";
    private static final String LONG_QUERY = "UNWIND range(0, 10000000) AS i CREATE (n:Node {idx: i}) DELETE n";
    private final int seed = new Random().nextInt();
    private final Random rand = new Random(this.seed);
    private final AssertableLogProvider internalLogProvider = new SpiedAssertableLogProvider(Connection.class);
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    @Inject
    private Neo4jWithSocket server;
    private InetSocketAddress address;
    private final BoltWire wire = new BoltDefaultWire();

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.server.setGraphDatabaseFactory(this.getTestGraphDatabaseFactory());
        this.server.setConfigure(ResetFuzzIT.getSettingsFunction());
        this.server.init(testInfo);
        this.address = (InetSocketAddress)this.server.lookupDefaultConnector().toSocketAddress();
    }

    @AfterEach
    public void tearDown() {
        this.userLogProvider.print(System.out);
        this.internalLogProvider.print(System.out);
    }

    @Test
    @Timeout(value=1L, unit=TimeUnit.MINUTES)
    public void shouldTerminateAutoCommitQuery() throws Exception {
        RequestSequenceCollection sequences = new RequestSequenceCollection().with(new ByteBuf[]{this.wire.run(SHORT_QUERY_1), this.wire.pull()}).with(new ByteBuf[]{this.wire.run(SHORT_QUERY_2), this.wire.discard()}).with(new ByteBuf[]{this.wire.run(SHORT_QUERY_3)});
        this.execute(sequences);
    }

    @Test
    @Timeout(value=1L, unit=TimeUnit.MINUTES)
    public void shouldTerminateLongRunningAutoCommitQuery() throws Exception {
        RequestSequenceCollection sequences = new RequestSequenceCollection().with(new ByteBuf[]{this.wire.run(LONG_QUERY), this.wire.discard()});
        this.execute(sequences);
    }

    @Test
    @Timeout(value=1L, unit=TimeUnit.MINUTES)
    public void shouldTerminateQueryInExplicitTransaction() throws Exception {
        RequestSequenceCollection sequences = new RequestSequenceCollection().with(new ByteBuf[]{this.wire.begin(), this.wire.run(SHORT_QUERY_1), this.wire.pull(), this.wire.rollback()}).with(new ByteBuf[]{this.wire.begin(), this.wire.run(SHORT_QUERY_2), this.wire.pull(), this.wire.commit()}).with(new ByteBuf[]{this.wire.begin(), this.wire.run(SHORT_QUERY_3), this.wire.pull()}).with(new ByteBuf[]{this.wire.begin(), this.wire.run(SHORT_QUERY_1)}).with(new ByteBuf[]{this.wire.begin()});
        this.execute(sequences);
    }

    @Test
    @Timeout(value=1L, unit=TimeUnit.MINUTES)
    public void shouldTerminateLongRunningQueryInExplicitTransaction() throws Exception {
        RequestSequenceCollection sequences = new RequestSequenceCollection().with(new ByteBuf[]{this.wire.begin(), this.wire.run(LONG_QUERY), this.wire.pull(), this.wire.rollback()});
        this.execute(sequences);
    }

    private void execute(RequestSequenceCollection sequences) throws Exception {
        BoltTestConnection connection = this.connectAndAuthenticate();
        long deadline = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < deadline) {
            RequestSequence request = sequences.execute(connection, this.rand);
            connection.send(this.wire.reset());
            request.assertResponseOrRecord(connection);
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        }
    }

    private BoltTestConnection connectAndAuthenticate() throws Exception {
        BoltTestConnection connection = new SocketConnection(this.address).connect().sendDefaultProtocolVersion().send(this.wire.hello());
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).negotiatesDefaultVersion();
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
        return connection;
    }

    private TestDatabaseManagementServiceBuilder getTestGraphDatabaseFactory() {
        TestDatabaseManagementServiceBuilder factory = new TestDatabaseManagementServiceBuilder();
        factory.setInternalLogProvider((InternalLogProvider)this.internalLogProvider);
        factory.setUserLogProvider((LogProvider)this.userLogProvider);
        return factory;
    }

    private static Consumer<Map<Setting<?>, Object>> getSettingsFunction() {
        return settings -> {
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
            settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
            settings.put(BoltConnectorInternalSettings.unsupported_thread_pool_queue_size, -1);
            settings.put(BoltConnector.thread_pool_min_size, 1);
            settings.put(BoltConnector.thread_pool_max_size, 1);
        };
    }
}

