/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.struct;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.struct.AbstractStructArgumentIT;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.initializer.EnableFeature;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class StructArgumentIT
extends AbstractStructArgumentIT {
    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint2DIsSentWithInvalidCrsIdV40(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt(5L).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"5\"");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint2DIsSentWithInvalidCrsId(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt(5L).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"5\"", BoltConnectionAssertions.assertErrorCause((String)"50N42: Unexpected error has occurred. See debug log for details.", (GqlStatus)GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), (String)"error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details."));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint3DIsSentWithInvalidCrsIdV40(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt(1200L).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"1200\"");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint3DIsSentWithInvalidCrsId(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt(1200L).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"1200\"", BoltConnectionAssertions.assertErrorCause((String)"50N42: Unexpected error has occurred. See debug log for details.", (GqlStatus)GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), (String)"error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details."));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint2DDimensionsDoNotMatchV40(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN_3D.getCode()).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian-3d, x=3.15, y=4.012)");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint2DDimensionsDoNotMatch(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN_3D.getCode()).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian-3d, x=3.15, y=4.012)", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N24: Cannot construct a point from [3.15, 4.012].", (GqlStatus)GqlStatusInfoCodes.STATUS_22N24.getGqlStatus(), (String)"error: data exception - invalid coordinate arguments. Cannot construct a point from [3.15, 4.012].", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"50N42: Unexpected error has occurred. See debug log for details.", (GqlStatus)GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), (String)"error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details."))));
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint3DDimensionsDoNotMatchV40(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN.getCode()).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian, x=3.15, y=4.012, z=5.905)");
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenPoint3DDimensionsDoNotMatch(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN.getCode()).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian, x=3.15, y=4.012, z=5.905)", BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"08N06: General network protocol error.", (GqlStatus)GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), (String)"error: connection exception - protocol error. General network protocol error.", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCauseWithInnerCause((String)"22N24: Cannot construct a point from [3.15, 4.012, 5.905].", (GqlStatus)GqlStatusInfoCodes.STATUS_22N24.getGqlStatus(), (String)"error: data exception - invalid coordinate arguments. Cannot construct a point from [3.15, 4.012, 5.905].", (Consumer)BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), (Consumer)BoltConnectionAssertions.assertErrorCause((String)"50N42: Unexpected error has occurred. See debug log for details.", (GqlStatus)GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), (String)"error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details."))));
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    @IncludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenZonedDateTimeZoneIdIsNotKnownV40(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValueV40(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.DATE_TIME_ZONE_ID.getTag())).writeInt(0L).writeInt(0L).writeString("Europe/Marmaris"), "Illegal value for field \"params\": Illegal value for field \"tz_id\": Illegal zone identifier: \"Europe/Marmaris\"");
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    @ExcludeWire(value={@Version(major=5, minor=6, range=6), @Version(major=4)})
    void shouldFailWhenZonedDateTimeZoneIdIsNotKnown(@Authenticated BoltTestConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.DATE_TIME_ZONE_ID.getTag())).writeInt(0L).writeInt(0L).writeString("Europe/Marmaris"), "Illegal value for field \"params\": Illegal value for field \"tz_id\": Illegal zone identifier: \"Europe/Marmaris\"", BoltConnectionAssertions.assertErrorCause((String)"50N42: Unexpected error has occurred. See debug log for details.", (GqlStatus)GqlStatusInfoCodes.STATUS_50N42.getGqlStatus(), (String)"error: general processing exception - unexpected error. Unexpected error has occurred. See debug log for details."));
    }
}

