/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.connection.initializer;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.connection.initializer.AbstractNegotiatingConnectionInitializer;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.error.BoltTestClientException;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.factory.HelloMessageBuilder;

public final class AuthenticateConnectionInitializer
extends AbstractNegotiatingConnectionInitializer {
    @Override
    public void initialize(ExtensionContext extensionContext, ParameterContext context, BoltWire wire, BoltTestConnection connection) throws ParameterResolutionException {
        ByteBuf command = this.getCommand(context, wire);
        try {
            connection.send(command);
            if (wire.supportsLogonMessage()) {
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess();
            } else {
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesSuccess(meta -> this.assertNegotiatedFeatures(wire, (Map<String, Object>)meta));
            }
        }
        catch (AssertionError | BoltTestClientException ex) {
            throw new ParameterResolutionException("Failed to authenticate connection", (Throwable)ex);
        }
    }

    private ByteBuf getCommand(ParameterContext context, BoltWire wire) {
        return context.findAnnotation(Authenticated.class).flatMap(annotation -> this.getCommand((Authenticated)annotation, wire)).orElseGet(() -> wire.supportsLogonMessage() ? wire.logon() : wire.hello());
    }

    private Optional<ByteBuf> getCommand(Authenticated annotation, BoltWire wire) {
        if (annotation.principal().isEmpty()) {
            return Optional.empty();
        }
        if (wire.supportsLogonMessage()) {
            return Optional.of(wire.logon(annotation.principal(), annotation.credentials()));
        }
        return Optional.of(wire.hello(x -> (HelloMessageBuilder)x.withBasicAuth(annotation.principal(), annotation.credentials())));
    }
}

