/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.wire.selector;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.test.wire.selector.BoltWireSelector;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.util.AnnotationUtil;

public class FilteredBoltWireSelector
implements BoltWireSelector {
    @Override
    public Stream<BoltWire> select(ExtensionContext context) {
        List explicitIncludes = AnnotationUtil.findAnnotation((ExtensionContext)context, IncludeWire.class).map(annotation -> Stream.of(annotation.value()).map(this::decodeVersion).toList()).orElseGet(Collections::emptyList);
        List explicitExcludes = AnnotationUtil.findAnnotation((ExtensionContext)context, ExcludeWire.class).map(annotation -> Stream.of(annotation.value()).map(this::decodeVersion).toList()).orElseGet(Collections::emptyList);
        return BoltWire.versions().filter(wire -> explicitIncludes.isEmpty() || explicitIncludes.stream().anyMatch(range -> range.matches(wire.getProtocolVersion()))).filter(wire -> explicitExcludes.stream().noneMatch(range -> range.matches(wire.getProtocolVersion())));
    }

    private ProtocolVersion decodeVersion(Version annotation) {
        if (annotation.minor() == -1) {
            return new ProtocolVersion(annotation.major(), 255, 255);
        }
        return new ProtocolVersion(annotation.major(), annotation.minor(), annotation.range());
    }
}

