/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class MalformedMessageIT {
    @TransportTest
    void shouldHandleIncorrectFraming(BoltWire wire, TransportConnection connection) throws Exception {
        ByteBuf msg = wire.run("UNWIND [1,2,3] AS a RETURN a, a * a AS a_squared");
        ByteBuf truncated = msg.readSlice(msg.readableBytes() - 12);
        connection.connect().sendDefaultProtocolVersion().send(truncated);
        ((BoltConnectionAssertions)BoltConnectionAssertions.assertThat((TransportConnection)connection).negotiatesDefaultVersion()).isEventuallyTerminated();
    }

    @ProtocolTest
    void shouldHandleMessagesWithIncorrectFields(@Authenticated TransportConnection connection) throws IOException {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN 1").writeMapHeader(0L).writeInt(42L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"metadata\": Unexpected type: Expected MAP but got INT");
    }

    @ProtocolTest
    void shouldHandleUnknownMarkerBytes(@Negotiated TransportConnection connection) throws IOException {
        PackstreamBuf msg = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeMarkerByte(199).writeMapHeader(0L).writeMapHeader(0L);
        connection.send(msg);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Request.Invalid, "Illegal value for field \"statement\": Unexpected type: Expected STRING but got RESERVED");
    }

    @TransportTest
    void shouldCloseConnectionOnInvalidHandshake(TransportConnection connection) throws IOException {
        connection.sendRaw(new byte[]{-34, -83, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
    }
}

