/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.fsm.v40.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.Signal;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v40.fsm.AutoCommitState;
import org.neo4j.bolt.protocol.v40.fsm.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.ReadyState;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class AutoCommitStateIT
extends BoltStateMachineV4StateTestBase {
    AutoCommitStateIT() {
    }

    @Test
    void shouldMoveFromAutoCommitToReadyOnPull_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInAutoCommitState();
        machine.process(BoltV40Messages.pull((long)100L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord().hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").containsKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(ReadyState.class);
    }

    @Test
    void shouldMoveFromAutoCommitToReadyOnPull_succ_hasMore() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInAutoCommitState("Unwind [1, 2, 3] as n return n");
        machine.process(BoltV40Messages.pull((long)2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)1L)}).hasRecord(new AnyValue[]{Values.longValue((long)2L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("has_more", (AnyValue)BooleanValue.TRUE).doesNotContainKey("db").doesNotContainKey("bookmark"));
        machine.process(BoltV40Messages.pull((long)2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)3L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").containsKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(ReadyState.class);
    }

    @Test
    void shouldMoveFromAutoCommitToReadyOnDiscardAll_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInAutoCommitState();
        machine.process(BoltV40Messages.discard((long)2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(ReadyState.class);
    }

    @Test
    void shouldMoveFromAutoCommitToInterruptedOnInterrupt() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInAutoCommitState();
        machine.process((RequestMessage)Signal.INTERRUPT, (ResponseHandler)recorder);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InterruptedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV4MessagesInAutoCommitState(RequestMessage message) throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInAutoCommitState("CREATE (n {k:'k'}) RETURN n.k");
        StateMachineAssertions.assertThat((StateMachine)machine).shouldKillConnection(fsm -> fsm.process(message, (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    private static Stream<RequestMessage> illegalV4Messages() {
        return Stream.of(BoltV40Messages.hello(), BoltV40Messages.run((String)"any string"), BoltV40Messages.begin(), BoltV40Messages.rollback(), BoltV40Messages.commit(), BoltV40Messages.reset(), BoltV40Messages.goodbye());
    }

    private StateMachineV40 getBoltStateMachineInAutoCommitState() throws BoltConnectionFatality {
        return this.getBoltStateMachineInAutoCommitState("CREATE (n {k:'k'}) RETURN n.k");
    }

    private StateMachineV40 getBoltStateMachineInAutoCommitState(String query) throws BoltConnectionFatality {
        StateMachineV40 machine = this.newStateMachine();
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)query), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(AutoCommitState.class);
        return machine;
    }
}

