/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.util.Map;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v44.BoltProtocolV44;
import org.neo4j.bolt.protocol.v44.fsm.StateMachineV44;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltV44Messages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.internal.Version;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class BoltConnectionAuthIT {
    @RegisterExtension
    static final SessionExtension env = new SessionExtension().withAuthEnabled(true);

    BoltConnectionAuthIT() {
    }

    protected StateMachineV44 newStateMachine() {
        return (StateMachineV44)env.newMachine(BoltProtocolV44.VERSION);
    }

    @Test
    void shouldGiveCredentialsExpiredStatusOnExpiredCredentials() throws Throwable {
        StateMachineV44 machine = this.newStateMachine();
        ResponseRecorder recorder = new ResponseRecorder();
        RequestMessage hello = BoltV44Messages.hello((Map)AuthToken.newBasicAuthToken((String)"neo4j", (String)"neo4j"));
        machine.process(hello, (ResponseHandler)recorder);
        machine.process(BoltV44Messages.run((String)"CREATE ()"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("credentials_expired", (AnyValue)Values.TRUE)).hasFailureResponse((Status)Status.Security.CredentialsExpired);
    }

    @Test
    void shouldGiveKernelVersionOnInit() throws Throwable {
        StateMachineV44 machine = this.newStateMachine();
        ResponseRecorder recorder = new ResponseRecorder();
        String version = "Neo4j/" + Version.getNeo4jVersion();
        RequestMessage hello = BoltV44Messages.hello((Map)AuthToken.newBasicAuthToken((String)"neo4j", (String)"neo4j"));
        machine.process(hello, (ResponseHandler)recorder);
        machine.process(BoltV44Messages.run((String)"CREATE ()"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).extractingEntry("server").isEqualTo(version));
    }

    @Test
    void shouldCloseConnectionAfterAuthenticationFailure() throws Throwable {
        StateMachineV44 machine = this.newStateMachine();
        ResponseRecorder recorder = new ResponseRecorder();
        RequestMessage hello = BoltV44Messages.hello((Map)AuthToken.newBasicAuthToken((String)"neo4j", (String)"j4oen"));
        StateMachineAssertions.assertThat((StateMachine)machine).shouldKillConnection(fsm -> fsm.process(hello, (ResponseHandler)recorder));
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Security.Unauthorized);
    }
}

